<!doctype html>
<?php
include("../connection.php");
include("../user.php");
$cur_date = date('Y-m-d H:i:s');
$sys_date = date('d-m-Y');
$user = $_SESSION['user'];
$branch_id = $_SESSION['branch_id'];
$ho_access = $_SESSION['ha'];
$location = $_SESSION['location'];

?>
<html class="no-js" lang="">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title><?php echo TITLE; ?></title>
	<meta name="description" content="Ela Admin - HTML5 Admin Template">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="apple-touch-icon" href="../images/bluebase.png">
	<link rel="shortcut icon" href="../images/bluebase.png">
	<style>
		input {
			text-transform: uppercase;
		}

		textarea {
			text-transform: uppercase;
		}
	</style>
</head>

<body>
	<div class="col-lg-8">
		<div class="card">
			<div class="card-header">
				<strong>Inward Creation</strong>
				<a href="inward_master.php"><button class="btn btn-primary" style="width:50px;float:right;" onclick=""><i class="fa fa-backward"></i></button></a>
			</div>
			<div class="card-body card-block">
				<form method="POST" enctype="multipart/form-data" class="form-horizontal" action="inward_submit.php">
					<?php
					if ($ho_access == "yes") {
					?>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">LOCATION</label></div>
							<div class="col-12 col-md-9">
								<select class="form-control" name="location" id="location">
									<?php
									$location = mysqli_query($con, "SELECT * FROM location_master where status='0'");
									?><option value="">SELECT LOCATION</option><?php
													while ($location_det = mysqli_fetch_array($location)) { ?>
										<option value="<?php echo $location_det['id']; ?>"><?php echo strtoupper($location_det['location']); ?></option>
									<?php	}	?>
								</select>
							</div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">DIVISION</label></div>
							<div class="col-12 col-md-9">
								<select class="form-control" name="division" id="division">
									<?php
									$division = mysqli_query($con, "SELECT * FROM branch_master where status='0'");
									?>
									<option value="">CHOOSE DIVISION</option>
									<?php
									while ($division_det = mysqli_fetch_array($division)) { ?>
										<option value="<?php echo $division_det['id']; ?>"><?php echo strtoupper($division_det['branch_name']); ?></option>
									<?php	}	?>
								</select>
							</div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">DEPARTMENT</label><span style="color:red;">*</span></div>
							<div class="col-12 col-md-9">
								<select class="form-control" name="department" id="department" required="true">
									<?php
									$department = mysqli_query($con, "SELECT * FROM type_master where status='0'");
									?>
									<option value="">CHOOSE DEPARTMENT</option>
									<?php
									while ($department_det = mysqli_fetch_array($department)) { ?>
										<option value="<?php echo $department_det['id']; ?>"><?php echo strtoupper($department_det['type']); ?></option>
									<?php	}	?>
								</select>
							</div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">STOCK</label><span style="color:red;">*</span></div>
							<div class="col-12 col-md-9">
								<select class="form-control" name="category" id="category" required="true">
									<?php
									$category = mysqli_query($con, "SELECT * FROM category_master where status='0'");
									?>
									<option value="">CHOOSE STOCK</option>
									<?php
									while ($category_det = mysqli_fetch_array($category)) { ?>
										<option value="<?php echo $category_det['id']; ?>"><?php echo strtoupper($category_det['category_type'] . '-' . $category_det['category_description']); ?></option>
									<?php	}	?>
								</select>
							</div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="brand_name" class="form-control-label">BRAND NAME</label><span style="color:red;">*</span></div>
							<div class="col-12 col-md-9"><input type="text" id="brand_name" name="brand_name" class="form-control" placeholder="Enter Brand Name" required></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="vendor_name" class="form-control-label">VENDOR NAME</label></div>
							<div class="col-12 col-md-9">
								<select class="form-control" name="vendor_name" id="vendor_name">
									<option value="">CHOOSE VENDOR</option>
									<?php
									$vendors = mysqli_query($con, "SELECT * FROM vendor_master WHERE status='0'");
									while ($vendor = mysqli_fetch_array($vendors)) {
									?>
										<option value="<?php echo $vendor['id']; ?>"><?php echo strtoupper($vendor['vendor_name']); ?></option>
									<?php
									}
									?>
								</select>
							</div>
						</div>


						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">BILL/NO DC</label></div>
							<div class="col-12 col-md-9"><input type="text" id="billno" name="billno" class="form-control" placeholder="Enter Bill NO" autocomplete="off"></div>
						</div>


						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">GATE_ENTRY</label></div>
							<div class="col-12 col-md-9"><input type="text" id="gatentry" name="gatentry" class="form-control" placeholder="Enter Gaten_Entry" autocomplete="off"></div>
						</div>

						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">HSN Code</label></div>
							<div class="col-12 col-md-9"><input type="text" id="hsncode" name="hsncode" class="form-control" placeholder="Enter HSNcode" autocomplete="off"></div>
						</div>




						<div class="container mt-5">
							<div class="row form-group">
								<div class="col col-md-3">
									<label or="text-input" class=" form-control-label">ASSET TYPE</label>
								</div>
								<div class="col-12 col-md-9">
									<select id="asset-select" class="form-control">
										<option value="">-- Select --</option>
										<option value="asset">Asset</option>
										<option value="non-asset">Non-Asset</option>
									</select>
								</div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">QUANTITY</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9">
									<input type="number" id="qty" name="qty" onchange="fa_serial_get()" class="form-control" placeholder="Enter Quantity" autocomplete="off" required>
								</div>

								<div class="row form-group" id="serial-number-row" style="display: none;">
									<div class="col col-md-3">
										<label for="fa" class="form-control-label">S.NO</label>
									</div>
									<div class="col-12 col-md-9" id="serial-number-container">
										<!-- <input type="text" id="fa" name="fa_serial_no" class="form-control" autocomplete="off" placeholder="Enter FA Serial Number"> -->
									</div>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">VALUE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="value" name="value" onchange="qtys(this.value)" class="form-control" placeholder="Enter Value" autocomplete="off"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">AMOUNT</label></div>
								<div class="col-12 col-md-9"><input type="number" id="amount" name="amount" class="form-control" autocomplete="off" Placeholder="AMOUNT" readonly></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="cars" class=" form-control-label">GST TYPE:</label></div>
								<div class="col-12 col-md-9">
									<select name="gst_type" id="gst_type" onchange="gsttype(this.value);" class="form-control">

										<option value="gst">GST</option>
										<option value="igst">IGST</option>
										<option value="sgst">SGST</option>
										<option value="ugst">UGST</option>

									</select>

								</div>
							</div>

							<div class="row form-group" style="display: none;" id="gst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">GST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="gst_percentage" name="gst_percentage" class="form-control" placeholder="Enter GST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="igst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">IGST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="igst_percentage" name="igst_percentage" class="form-control" placeholder="Enter IGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="sgst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">SGST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="sgst_percentage" name="sgst_percentage" class="form-control" placeholder="Enter SGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="cgst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">CGST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="cgst_percentage" name="cgst_percentage" class="form-control" placeholder="Enter CGST Percentage" onchange="calculateTotalAmount()" ></div>
							</div>

							<div class="row form-group" style="display: none;" id="ugst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">UGST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="ugst_percentage" name="ugst_percentage" class="form-control" placeholder="Enter UGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="total_amount" class="form-control-label">TOTAL AMOUNT</label></div>
								<div class="col-12 col-md-9"><input type="number" id="total_amount" name="total_amount" class="form-control" placeholder="Total Amount" readonly></div>
							</div>


							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">DEPRECIATION AMOUNT</label></div>
								<div class="col-12 col-md-9"><input type="number" id="dep_amount" name="dep_amount" class="form-control" autocomplete="off" Placeholder="DEPRECIATION AMOUNT"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">PURCHASE DATE</label></div>
								<div class="col-12 col-md-9"><input type="date" id="po_date" name="po_date" class="form-control" autocomplete="off"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="amc_date_from" class="form-control-label">AMC DATE FROM</label></div>
								<div class="col-12 col-md-9"><input type="date" id="amc_date_from" name="amc_date_from" class="form-control"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="amc_date_to" class="form-control-label">AMC DATE TO</label></div>
								<div class="col-12 col-md-9"><input type="date" id="amc_date_to" name="amc_date_to" class="form-control"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">REMARKS</label></div>
								<div class="col-12 col-md-9"><input type="text" id="remarks" name="remarks" class="form-control" autocomplete="off" placeholder="Enter Remarks"></div>
							</div>
							</td>
							</tr>
							</tbody>
							</table>
						<?php
					} else {
						?>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">LOCATION</label></div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="location" id="location" readonly>
										<?php
										$location = mysqli_query($con, "SELECT * FROM location_master where location='$location' and status='0'");

										while ($location_det = mysqli_fetch_array($location)) { ?>
											<option value="<?php echo $location_det['id']; ?>"><?php echo strtoupper($location_det['location']); ?></option>
										<?php	}	?>
									</select>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">DIVISION</label></div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="division" id="division" readonly>
										<?php
										$division = mysqli_query($con, "SELECT * FROM branch_master where id='$branch_id' and status='0'");
										?>
										<?php
										while ($division_det = mysqli_fetch_array($division)) { ?>
											<option value="<?php echo $division_det['id']; ?>"><?php echo strtoupper($division_det['branch_name']); ?></option>
										<?php	}	?>
									</select>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">DEPARTMENT</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="department" id="department" required="true">
										<?php
										$department = mysqli_query($con, "SELECT * FROM type_master where status='0'");
										?>
										<option value="">CHOOSE DEPARTMENT</option>
										<?php
										while ($department_det = mysqli_fetch_array($department)) { ?>
											<option value="<?php echo $department_det['id']; ?>"><?php echo strtoupper($department_det['type']); ?></option>
										<?php	}	?>
									</select>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">STOCK</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="category" id="category" required="true">
										<?php
										$category = mysqli_query($con, "SELECT * FROM category_master where status='0'");
										?>
										<option value="">CHOOSE STOCK</option>
										<?php
										while ($category_det = mysqli_fetch_array($category)) { ?>
											<option value="<?php echo $category_det['id']; ?>"><?php echo strtoupper($category_det['category_type'] . '-' . $category_det['category_description']); ?></option>
										<?php	}	?>
									</select>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="brand_name" class="form-control-label">BRAND NAME</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="text" id="brand_name" name="brand_name" class="form-control" placeholder="Enter Brand Name" required></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="vendor_name" class="form-control-label">VENDOR NAME</label></div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="vendor_name" id="vendor_name">
										<option value="">CHOOSE VENDOR</option>
										<?php
										$vendors = mysqli_query($con, "SELECT * FROM vendor_master WHERE status='0'");
										while ($vendor = mysqli_fetch_array($vendors)) {
										?>
											<option value="<?php echo $vendor['id']; ?>"><?php echo strtoupper($vendor['vendor_name']); ?></option>
										<?php
										}
										?>
									</select>
								</div>
							</div>


							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">BILL/NO DC</label></div>
								<div class="col-12 col-md-9"><input type="text" id="billno" name="billno" class="form-control" placeholder="Enter Bill NO" autocomplete="off"></div>
							</div>


							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">GATE_ENTRY</label></div>
								<div class="col-12 col-md-9"><input type="text" id="gatentry" name="gatentry" class="form-control" placeholder="Enter Gate_Entry" autocomplete="off"></div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">HSN Code</label></div>
								<div class="col-12 col-md-9"><input type="text" id="hsncode" name="hsncode" class="form-control" placeholder="Enter HSNcode" autocomplete="off"></div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">QUANTITY</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="qty" name="qty" onchange="fa_serial_get()" class="form-control" placeholder="Enter Quantity" autocomplete="off" required></div>
							</div>

							<div class="container mt-5">
								<div class="row form-group">
									<div class="col col-md-3">
										<label for="asset-select" class="form-control-label">ASSET TYPE</label>
									</div>
									<div class="col-12 col-md-9">
										<select id="asset-select" class="form-control">
											<option value="">-- Select --</option>
											<option value="asset">Asset</option>
											<option value="non-asset">Non-Asset</option>
										</select>
									</div>
								</div>

								<div class="row form-group" id="serial-number-row" style="display: none;">
									<div class="col col-md-3">
										<label for="fa" class="form-control-label">S.NO</label>
									</div>
									<div class="col-12 col-md-9">
										<input type="text" id="fa" name="fa_serial_no[]" class="form-control" autocomplete="off" placeholder="Enter FA Serial Number">
									</div>
								</div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">VALUE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="value" name="value" onchange="qtys(this.value)" class="form-control" placeholder="Enter Value" autocomplete="off"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3">
									<label for="amount" class="form-control-label">AMOUNT</label>
								</div>
								<div class="col-12 col-md-9">
									<input type="number" id="amount" name="amount" class="form-control" autocomplete="off" placeholder="AMOUNT" readonly>
								</div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3">
									<label for="gst_type" class="form-control-label">GST TYPE:</label>
								</div>
								<div class="col-12 col-md-9">
									<select class="form-control" name="gst_type" id="gst_type" onchange="gsttype(this.value);">
										<option value="">-- Select GST Type --</option>
										<option value="gst">GST</option>
										<option value="igst">IGST</option>
										<option value="sgst">SGST</option>
										<option value="ugst">UGST</option>
									</select>
								</div>
							</div>


							<div class="row form-group" style="display: none;" id="gst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">GST PERCENTAGE</label><span style="color:red;">*</span></div>
								<div class="col-12 col-md-9"><input type="number" id="gst_percentage" name="gst_percentage" class="form-control" placeholder="Enter GST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="igst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">IGST PERCENTAGE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="igst_percentage" name="igst_percentage" class="form-control" placeholder="Enter IGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="sgst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">SGST PERCENTAGE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="sgst_percentage" name="sgst_percentage" class="form-control" placeholder="Enter SGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="cgst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">CGST PERCENTAGE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="cgst_percentage" name="cgst_percentage" class="form-control" placeholder="Enter CGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group" style="display: none;" id="ugst">
								<div class="col col-md-3"><label for="gst_percentage" class="form-control-label">UGST PERCENTAGE</label></div>
								<div class="col-12 col-md-9"><input type="number" id="ugst_percentage" name="ugst_percentage" class="form-control" placeholder="Enter UGST Percentage" onchange="calculateTotalAmount()"></div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="total_amount" class="form-control-label">TOTAL AMOUNT</label></div>
								<div class="col-12 col-md-9"><input type="number" id="total_amount" name="total_amount" class="form-control" placeholder="Total Amount" readonly></div>
							</div>

							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">DEPRECIATION AMOUNT</label></div>
								<div class="col-12 col-md-9"><input type="number" id="dep_amount" name="dep_amount" class="form-control" autocomplete="off" Placeholder="DEPRECIATION AMOUNT"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">PURCHASE DATE</label></div>
								<div class="col-12 col-md-9"><input type="date" id="po_date" name="po_date" class="form-control" autocomplete="off"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="amc_date_from" class="form-control-label">AMC DATE FROM</label></div>
								<div class="col-12 col-md-9"><input type="date" id="amc_date_from" name="amc_date_from" class="form-control"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="amc_date_to" class="form-control-label">AMC DATE TO</label></div>
								<div class="col-12 col-md-9"><input type="date" id="amc_date_to" name="amc_date_to" class="form-control"></div>
							</div>
							<div class="row form-group">
								<div class="col col-md-3"><label for="text-input" class=" form-control-label">REMARKS</label></div>
								<div class="col-12 col-md-9"><input type="text" id="remarks" name="remarks" class="form-control" autocomplete="off" placeholder="Enter Remarks"></div>
							</div>
							</tbody>
							</table>
						<?php }	?>

						<div>
							<button type="submit" name="submit" title="Submit" class="btn btn-success btn btn-lg" style="float:right"><i class="fa fa-dot-circle-o"></i> Submit</button>

						</div>
				</form>
			</div>
		</div>
		<div class="clearfix"></div>

		<footer class="site-footer">

		</footer>

	</div><!-- /#right-panel -->
</body>

</html>
<script>
	function gsttype(val) {
		if (val == 'gst') {
			$('#gst').show();
			$('#igst').hide();
			$('#sgst').hide();
			$('#ugst').hide();
		} else if (val == 'igst') {
			$('#igst').show();
			$('#sgst').hide();
			$('#ugst').hide();
			$('#gst').hide();
		} else if (val == 'sgst') {
			$('#sgst').show();
			$('#ugst').hide();
			$('#igst').hide();
			$('#gst').hide();
		} else if (val == 'ugst') {
			$('#ugst').show();
			$('#gst').hide();
			$('#sgst').hide();
			$('#igst').hide();
		}
	}


	function deleteRow(btn) {
		var row = btn.parentNode.parentNode;
		row.parentNode.removeChild(row);
	}

	function qtys(value) {
		var quantity = $("#qty").val();
		var mul_price = (quantity) * (value);
		$('#amount').val(mul_price);
	}
</script>

<script>
	function calculateTotalAmount() {
		const value = parseFloat(document.getElementById('value').value) || 0;
		const gstPercentage = parseFloat(document.getElementById('gst_percentage').value) || 0;
		const totalAmount = value + (value * gstPercentage / 100);
		document.getElementById('total_amount').value = totalAmount.toFixed(2);
	}
</script>
<script>
	$(document).ready(function() {
		$('#asset-select').change(function() {
			// Get the selected value
			const selectedValue = $(this).val();
			// Show or hide the S.NO input based on the selected value
			if (selectedValue === 'asset') {
				$('#serial-number-row').show(); // Show the S.NO row if 'Asset' is selected
			} else {
				$('#serial-number-row').hide(); // Hide the S.NO row for any other selection
			}
		});
	});
</script>

<script>
	function fa_serial_get() {
		debugger;
		var qty = document.getElementById('qty').value;
		var serialRow = document.getElementById('serial-number-row');
		var serialContainer = document.getElementById('serial-number-container');

		// Clear previous serial number fields
		serialContainer.innerHTML = '';

		if (qty > 0) {
			serialRow.style.display = 'block'; // Show the serial number section

			// Generate input fields based on the quantity entered
			for (var i = 1; i <= qty; i++) {
				var input = document.createElement('input');
				input.type = 'text';
				input.name = 'fa_serial_no'; // Using array notation to store multiple values
				input.id = 'fa_serial_no-' + i;
				input.className = 'form-control'; // Add margin for spacing between inputs
				input.placeholder = 'Enter FA Serial Number ' + i;
				input.autocomplete = 'off';

				serialContainer.appendChild(input);
			}
		} else {
			serialRow.style.display = 'none'; // Hide the serial number section if quantity is 0 or invalid
		}
	}
</script>