<?php 
require("../connection.php");
include("../user.php");

$user_id = $_SESSION['user'];
$username = $_SESSION['user_name'];
$branch = $_SESSION['division_name'];
?>

<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo TITLE;?></title>
    <meta name="description" content="Ela Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="../images/bluebase.png">
    <link rel="shortcut icon" href="../images/bluebase.png">

    <link rel="stylesheet" href="../css/normalize.min.css">
    <link rel="stylesheet" href="../css/bootstrap.min.css">
    <link rel="stylesheet" href="../css/font-awesome.min.css">
    <link rel="stylesheet" href="../css/themify-icons.css">
    <link rel="stylesheet" href="../css/pe-icon-7-stroke.min.css">
    <link rel="stylesheet" href="../css/flag-icon.min.css">
    <link rel="stylesheet" href="../assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="../css/chartist.min.css" rel="stylesheet">
    <link href="../css/jqvmap.min.css" rel="stylesheet">
    <link href="../css/weather-icons.css" rel="stylesheet" />
    <link href="../css/fullcalendar.min.css" rel="stylesheet" />

    <script src="../js/jquery-3.3.1.min.js"></script>
    <script src="../js/jquery.dataTables.min.js"></script>
    <script src="../js/popper.min.js"></script>
    <script src="../js/bootstrap.min.js"></script>
    <script src="../js/jquery.matchHeight.min.js"></script>
    <script src="../assets/js/main.js"></script>

    <!-- SweetAlert2 CSS and JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        #description {
            white-space: pre-wrap; /* Preserve whitespace and line breaks */
            word-wrap: break-word; /* Break long words */
        }
    </style>

    <link rel="stylesheet" href="/project_temp/datatable/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="/project_temp/button/css/buttons.css" />

</head>
<body>




    <?php require('../sidemenu.php');?>

    <div id="right-panel" class="right-panel">
        <?php require('../header.php');?>

        <div class="content">
            <div class="animated fadeIn">
                <div style="background-color:white;margin-bottom:10px;">
                    <strong style="color:blue"><center>LIST OF MATERIAL</center></strong>
                </div>

                <label for="category">Choose a Category:</label>
                <select name="materialname" id="materialname" onchange="fetchDescription(this.value)">
                    <option value="">Select a category</option>
                    <?php
                    $row = mysqli_query($con, "SELECT DISTINCT category FROM `item_master` ORDER BY id DESC");
                    while($type = mysqli_fetch_array($row)) {
                        echo '<option value="'.$type['category'].'">'.$type['category'].'</option>';
                    }
                    ?>
                </select>
                <br><br>

                <?php
                // Get the current month and previous month
                $currentMonth = date('F');
                $previousMonth = date('F', strtotime("-1 month"));
                $daysInMonth = date('t');
                ?>

                <table id="example" class="table table-striped table-bordered" style="text-transform:uppercase;">
                    <thead>
                    <tr>
                        <th>Material Name</th>
                        <th><?php echo $previousMonth; ?> Carry Forward</th>
                        <th>Stock In <?php echo $currentMonth; ?></th>
                        <th>Pre Bal</th>
                        <th>Qum</th>
                        <th>Open Bal</th>
                        <?php
                        for ($day = 1; $day <= $daysInMonth; $day++) {
                            echo '<th>' . $day . ' ' . $currentMonth . '</th>';
                        }
                        ?>
                        <th>Total Given</th>
                        <th>Closing Bal</th>
                        <th>Required to Order</th>
                        <th>M. No</th>
                    </tr>
                    </thead>
                    <tbody>
                    <!-- Rows will be inserted here by JavaScript -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php require("../mainjavascript.js"); ?>
    <script src="../js/jquery-3.3.1.min.js"></script>
<script src="../js/your-script.js"></script> <!-- Ensure this script comes after jQuery -->

    <script>
        $(document).ready(function() {
    $('#example').DataTable(); // Initialize DataTable

    $('#materialname').change(function() {
        fetchDescription($(this).val()); // Fetch description on category change
    });
});
function fetchDescription(category) {
    if (category !== "") {
        $.ajax({
            url: "fetch_description.php",
            type: "GET",
            data: { category: category },
            dataType: "json",  // Make sure to specify JSON response
            success: function(response) {
                var descriptions = response.descriptions;  // The descriptions array
                var prevMonthQuantity = response.prev_month_quantity || 0;  // Previous month quantity, default to 0
                var currentMonthQuantity = response.current_month_quantity || 0;  // Current month quantity, default to 0
                
                var tableBody = $('#example tbody');
                tableBody.empty(); // Clear existing rows
               var iii='-';
                // Check if descriptions is an array and not empty
                if (Array.isArray(descriptions) && descriptions.length > 0) {
                    descriptions.forEach(function(item) {
                        var row = $('<tr>');
                        row.append('<td>' + (item.category_description || 'N/A') + '</td>'); // Description column
                        row.append('<td>' + prevMonthQuantity + '</td>'); // Previous month quantity
                        row.append('<td>' + currentMonthQuantity + '</td>'); // Current month quantity
                        row.append('<td>' + currentMonthQuantity + '</td>');
                        row.append('<td>' + iii + '</td>');
                        row.append('<td>' + currentMonthQuantity + '</td>');
                        tableBody.append(row);
                    });
                } else {
                    tableBody.append('<tr><td colspan="3">No data available</td></tr>'); // Adjust colspan if needed
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error: " + status + " - " + error);
            }
        });
    } else {
        $('#example tbody').empty(); // Clear existing rows if no category selected
    }
}





    </script>
</body>
</html>
