<?php
include("../connection.php");
include("../user.php");
$cur_date = date('Y-m-d H:i:s');
$user = $_SESSION['user'];
$category_list = mysqli_query($con, "SELECT MAX(category_id) AS id FROM `category_master` LIMIt 1");
if ($row = mysqli_fetch_assoc($category_list)) {
	$lastCode = $row['id'];
	$lastNumber = (int) substr($lastCode, 3); // Get the numeric part
// 	echo $lastNumber;
// 	exit;
	$newNumber = $lastNumber + 1;
	$Catid = "mt-" . str_pad($newNumber, 4, "0", STR_PAD_LEFT); // Generate new code
} else {
	$Catid = "mt-0001"; // Default if no records found
}
?>
<!doctype html>
<html class="no-js" lang="">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title><?php echo TITLE; ?></title>
	<meta name="description" content="Ela Admin - HTML5 Admin Template">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="apple-touch-icon" href="../images/bluebase.png">
	<link rel="shortcut icon" href="../images/bluebase.png">
	<!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

	<style>
		input {
			text-transform: uppercase;
		}

		textarea {
			text-transform: uppercase;
		}

		.measurement-input {
			display: none;
		}
	</style>
</head>

<body>
	<div class="col-lg-10">
		<div class="card">
			<div class="card-header">
				<strong>Stock Creation</strong>
				<a href="category_master.php">
					<button class="btn btn-primary" style="width:50px; margin-left:400px;">
						<i class="fa fa-backward"></i>
					</button>
				</a>
			</div>
			<div class="card-body card-block">
				<form method="post" enctype="multipart/form-data" class="form-horizontal" action="category_submit.php">
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Stock ID</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="text" id="category_id" name="category_id" placeholder="Enter Stock ID"
								class="form-control" autocomplete="off" value="<?php echo $Catid; ?>" readonly>
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="measurement_type" class="form-control-label">Department</label>
						</div>
						<div class="col-12 col-md-9">
							<select id="dept" name="dept" class="form-control select-search">
								<option value="">Select Department</option>
								<?php
								$brn = mysqli_query($con, "SELECT id,type FROM type_master where  status='0'");
								while ($brc = mysqli_fetch_array($brn)) {
									?>
									<option value="<?php echo $brc['id']; ?>"><?php echo strtoupper($brc['type']); ?>
									</option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Stock Name</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="text" id="category" name="category" placeholder="Enter Stock Name"
								class="form-control" autocomplete="off">
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Stock Availability</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="number" id="availability" name="availability" placeholder="Enter Availability"
								class="form-control" oninput="changeQuantity(this.value)" autocomplete="off">
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Stock Brand</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="text" id="brand" name="brand" placeholder="Enter Stock Brand"
								class="form-control" autocomplete="off">
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Stock Description</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="text" id="prefix" name="prefix" placeholder="Enter Stock Description"
								class="form-control" autocomplete="off">
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="measurement_type" class="form-control-label">Measurement Type</label>
							
						</div>
						<div class="col-12 col-md-9">
							<select id="measurement_type" name="measurement_type" class="form-control select-search">
								<option value="">Select Measurement Type</option>
								<?php
								$brn = mysqli_query($con, "SELECT id,name FROM measurement_master where  status='0'");
								while ($brc = mysqli_fetch_array($brn)) {
									?>
									<option value="<?php echo $brc['id']; ?>"><?php echo strtoupper($brc['name']); ?>
									</option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Price</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="number" id="price" name="price" placeholder="Enter Price" class="form-control"
								autocomplete="off" oninput="changePrice(this.value)" step="0.0001">
						</div>
					</div>
					<div class="row form-group">
						<div class="col col-md-3">
							<label for="text-input" class="form-control-label">Total Amount</label>
							
						</div>
						<div class="col-12 col-md-9">
							<input type="number" id="tol_amount" name="tol_amount" placeholder="Total Amount"
								class="form-control" autocomplete="off" readonly step="0.0001">
						</div>
					</div>
					<div style="">
						<button type="submit" name="submit" class="btn btn-success">
							<i class="fa fa-dot-circle-o"></i> Submit
						</button>
					</div>
				</form>
			</div>
		</div>
		<div class="clearfix"></div>
		<footer class="site-footer"></footer>
	</div>
	<script>
		$(document).ready(function () {
			$('.select-search').select2({
				placeholder: "-- SELECT --",
				allowClear: true
			});
		});
		function changeQuantity(value) {
			var price = parseFloat($("#price").val()) || 0;
			var total_amount = price * value;
			$('#tol_amount').val(total_amount.toFixed(2));
		}
		function changePrice(price) {
			var value = parseFloat($("#availability").val()) || 0;
			var total_amount = price * value;
			$('#tol_amount').val(total_amount.toFixed(2));
		}
	</script>
</body>

</html>