<?php
include("../connection.php");

// Get the last inserted vendor code
$result = mysqli_query($con, "SELECT vendor_code FROM vendor_master ORDER BY id DESC LIMIT 1");
$row = mysqli_fetch_assoc($result);

if ($row) {
    // Extract the number part from the last vendor code and increment it
    $lastCode = $row['vendor_code'];
    $lastNumber = intval(substr($lastCode, 4)); // Assuming "VEN-" prefix
    $newNumber = $lastNumber + 1;
    $newVendorCode = "VEN-" . str_pad($newNumber, 2, "0", STR_PAD_LEFT);
} else {
    // If no vendor code exists, start with "VEN-01"
    $newVendorCode = "VEN-01";
}

echo $newVendorCode;
?>
