<?php
include("../connection.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Sample data
$category_types = [
    'Long Size Note 192 Page ', 'Scribbling Pad', 'Long Size Scale SS 1 Ft', 'Brown Sheet Rool', 'Blue Pen', 'Correction Pen', 'permanent marker (Blue)', 'permanent marker (Red)', 'permanent marker (Black)', 'Highlighter ( All Colour )', 'White Board Duster', 'Whiteboard Marker', 'Pencil', 'A4  Sheet', 'A3  Sheet', 'Box File', 'Punching Machine  DP 600', 'Box file', 'Pouching  Pouch', 'Stapler Big', 'Stapler Pin no 10', 'Key Chian Tag', 'Stamp Pad Ink', 'Scissor Standerd  Size', 'Cello Tape 3"', 'Water Bottle', 'Cutter Big', 'Cutter Small', 'Battery AA', 'Battery AAA', 'Checked Cloth', 'Glass Cloth', 'Sponge Foam white', 'Scotch Bright Scrubbler (10rs)', 'Taski R2 (5Ltrs) Hard Surface Cleaner', 'Taski R3 (5Ltrs) Glass Cleaner', 'Taski R4 (5Ltrs) ', 'Taski R5 (5Ltrs) Air Freshner', 'Room Spray (British)', 'Taski R6 (5Ltrs) Toilet Cleaner', 'Taski R7 (5Ltrs) ', 'O R D 7 (5Ltrs) Steel Polish', 'Bleaching Water (5Ltrs)', 'Soap Oil', 'Acid (5 Ltrs)', 'Phenoil Compound', 'Detol Hand Wash pump (200 ml)', 'Aer Room Freshner Pocket', 'Air Wik Re fill 250 ml', 'Head Cap (white) (5 box)', 'Face Mask White (100 Pcs per 1 box)', 'Face Mask Black (100 Pcs per 1 box)', 'Googgle  Safty Glass', 'Cottan Gloves Gray', 'Surgical gloves (Blue) 1 Box', 'Rubber gloves', 'Uranial Cube', 'Mop Colour Head', 'Cob Web Refill', 'Mop White  Head', 'Soft Broom ', 'Hard Broom ', 'Bucket (15 lit)', 'Bucket (7 lit)', 'Dust Bin ', 'Bleaching Powder 1kg Packet', 'Dustbin Cover (36 x 48)', 'Dustbin Cover (17 x 19)', 'Funnel Big', 'Castick Soda', 'Cary Bag', 'Vim Bar', 'TCCL 90 Chlorine', 'Alallm', 'Algee Key', 'Sodaash', 'Test Kit', '4 "Green Metal Cutting Wheel     ', 'AE 0427', 'AE White', 'Brush 2 1/2"', 'Gala Mop with Stick', 'Gala Mop with Clip Re Fill', 'Caddy Kit', 'Funnel Small', 'Floor Mat', 'Spray Gun Small', 'Dust Pan', 'Plastic Tray', 'Class Mate Note Book', 'Staplar Machine  10.', 'Staplar Pin 24/ 6', 'Ball Pen', 'Rorito Blue Pen', 'Car Wheel Lock', '1 1/2" FT Bridge Clamp', '6" Green Hose', '8" PVC Pipe 4Kg', 'Solvent PVC', ' 1/2"Teflan Tape', '6" Hose Clip', '8" PVC End Cap', '6" PVC Elbow', '6" Hose Nipple', '10 mm Ancchor Fastner', '8" U Clamp with Net & Washer', '6" PVC Pipe 20 Feet ', '6" PVC MTA', '8" x 6" Reducer', '8" PVC Elbeow', '15 Watts Lobby Light', 'Health Fozir Set Parry Ware', 'Toilet Seat Parry ware', 'Wash Basin Piller Tap Piller Code', 'Angel Clock', 'Drain Grill  5 x 5', 'Closet P Trap Varmora Western', 'Conection Hose 1.5 Ft', 'Exhaurst Fan 150 mm', 'Long Body Tap', 'White Cement', 'Bottam Drop Hose Wast Hose', '4 Model Box With Switch Set', '6 Amps 3 Pin Socket', 'Axsha Blade', '15 Meter Mesuring Tape', 'Metal Cuting Blade   Sample', 'Gi Bold', 'Gi Bold', '4" Metal cutting Blade', 'One Feet Long Tap', '10" PVC End Cap', '1/2 x 12" Gi Nipple', '1/2 x 6" Gi Nipple', '1/2" Gi Elbow', '1/2" Brss Valve ', '6" PVC Flange ( 160 mm)', 'Sink Waste Cupler', '6" (12 MM) HT Bold Wither Washer', '4" (12 MM) HT Bold Wither Washer', 'POP ', 'Braking Bit ', '1 3/4" Screw Black', '3" Adsion Bit', '6 Amps Socket', '16 Amps Switch', '16 Amps  MCB Switch', '12 Model Gang Box ', '6" PVC FTA', 'Plumbing & Electrical', 'Center Nizzle', 'Laboue Charge & Testing Commissioning ', '', 'Online Filter', 'Under Wateer Light RGP', 'Valve Controller', '1 HP Pump', 'Center Nozzle', '40 Watts Cromption LED Blub', 'Umbrella Big Colour', 'Water Hose 1" ', 'Axha Blade ', 'M seal', 'Grees', 'Sanal Nool', 'Gl Wire', 'Cowbar 5 ft', 'Garding Spade', 'Chellak ', 'Hammer 2BD', 'Opnable door Handle Set', 'SS C.P.TEE 1/2"', 'X Nipple  1/2" 304 SS', '23 A VBattary', '2 model Frame', '20 Amps Socket', 'G2 GRASS', '3 X 2 1/2" Reducer', '3 X 2 " Reducer', '2" X 1 1/2 " Reducer', '8 x 12" Tower Bold AL Gold ', '10 Amps Switch', '8 module Frame', '200  Watts Flood Light', 'TARZO Swage Motor', '3/4" Brass Valve', 'Axha Blade Small', 'Claset Net Bold SS', 'Sanal Nool', '400 X 35 Glass ', '3 Watts Spot Light', '12 Watts 2 Ft Ligjht', 'Hose Clamp '
];

$departments = [
    'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'Stationary', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'swimming pool', 'swimming pool', 'swimming pool', 'swimming pool', 'swimming pool', 'Plumbing', 'Civil', 'Civil', 'Civil', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'HK', 'Eletrical', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Electrical', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Electrical', 'Plumbing', 'Plumbing', 'Plumbing', 'Electrical', 'Electrical', 'Plumbing', 'Plumbing', 'Plumbing', 'Civil', 'Civil', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Civil', 'Civil', 'Civil', 'Civil', 'Electrical', 'Electrical', 'Electrical', 'Electrical', '', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Swimming Pool', 'Electrical', 'Stationary', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Electrical', 'Electrical', 'Electrical', 'Garden', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Electrical', 'Electrical', 'Electrical', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Plumbing', 'Civil', 'Electrical', 'Electrical', 'Plumbing'
];

// Check if both arrays have the same length
if (count($category_types) !== count($departments)) {
    die("Error: category_types and departments arrays must have the same length.");
}

// Get the last category_id
$res = $con->query("SELECT MAX(CAST(SUBSTRING(category_id, 4) AS UNSIGNED)) AS last_id FROM category_master");
$row = $res->fetch_assoc();
$last_id = (int)$row['last_id'];
$counter = $last_id + 1;

for ($i = 0; $i < count($category_types); $i++) {
    $type = trim($category_types[$i]);
    $dept = trim($departments[$i]);

    if (empty($type) || empty($dept)) continue;

    // Check if category_type already exists
    $stmt = $con->prepare("SELECT 1 FROM category_master WHERE LOWER(category_type) = LOWER(?) LIMIT 1");
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo "⚠️ Skipped (already exists): $type<br>";
        $stmt->close();
        continue;
    }
    $stmt->close();

    // Fetch type_id from type_master
    $stmt = $con->prepare("SELECT id FROM type_master WHERE LOWER(type) = LOWER(?) LIMIT 1");
    $stmt->bind_param("s", $dept);
    $stmt->execute();
    $stmt->bind_result($type_id);
    if ($stmt->fetch()) {
        $new_id = sprintf("mt-%04d", $counter);
        $stmt->close();

        // Insert new category
        $ins = $con->prepare("INSERT INTO category_master (category_id, category_type, department) VALUES (?, ?, ?)");
        $ins->bind_param("sss", $new_id, $type, $type_id);
        $ins->execute();
        $ins->close();

        echo "✅ Inserted: $new_id - $type<br>";
        $counter++;
    } else {
        $stmt->close();
        echo "❌ Department not found for: '$dept'<br>";
    }
}

$con->close();
?>
