<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// --- Chatbot Logic ---
function hospital_bot_reply($message) {
    $msg = strtolower(trim($message));

    $responses = [
        "hi" => "Hello! Welcome to our hospital. How can I help you today?",
        "hello" => "Hi there! How can I assist you with hospital services?",
        "good morning" => "Good morning! How can I help you?",
        "good evening" => "Good evening! How may I assist you?",
        "doctor available" => "Yes, doctors are available from 9 AM to 8 PM.",
        "available doctors" => "You can check doctor schedules at the reception or HMS doctor schedule page.",
        "doctor timings" => "Our doctors are available from 9 AM to 8 PM, Monday to Saturday.",
        "book appointment" => "Sure! Please visit the appointment section in the HMS or reception desk.",
        "appointment" => "Appointments can be booked online in the HMS or at reception.",
        "cancel appointment" => "You can cancel appointments from your HMS account under 'My Appointments'.",
        "lab hours" => "The laboratory is open from 8 AM to 6 PM every day.",
        "test reports" => "You can collect lab reports from the Lab counter or download them from the HMS portal.",
        "billing" => "You can pay your bill at the billing counter or online via the HMS payment section.",
        "payment" => "Payments can be made via cash, card, or online in the HMS portal.",
        "emergency" => "For emergencies, please call 108 or visit our 24/7 Emergency Ward immediately.",
        "default" => "Sorry, I didn't understand that. Could you please rephrase?"
    ];

    if (isset($responses[$msg])) {
        return $responses[$msg];
    }

    if (strpos($msg, 'doctor') !== false) {
        return "For doctor availability, please check the schedule in the HMS or reception.";
    }
    if (strpos($msg, 'lab') !== false || strpos($msg, 'test') !== false) {
        return "The lab is open from 8 AM to 6 PM. Reports are available in the HMS.";
    }
    if (strpos($msg, 'bill') !== false || strpos($msg, 'payment') !== false) {
        return "Billing is available at the counter and online.";
    }
    if (strpos($msg, 'appointment') !== false) {
        return "Appointments can be booked via the HMS appointment section.";
    }
    if (strpos($msg, 'emergency') !== false) {
        return "For emergencies, call 108 or visit our Emergency Ward.";
    }

    return $responses["default"];
}

// --- Session History ---
if (!isset($_SESSION['chat_history'])) {
    $_SESSION['chat_history'] = [];
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['message'])) {
    $userMsg = trim($_POST['message']);
    if ($userMsg !== "") {
        $_SESSION['chat_history'][] = ["sender" => "You", "text" => htmlspecialchars($userMsg)];
        $botReply = hospital_bot_reply($userMsg);
        $_SESSION['chat_history'][] = ["sender" => "HMS Bot", "text" => htmlspecialchars($botReply)];
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_POST['clear'])) {
    $_SESSION['chat_history'] = [];
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>HMS Dashboard - Chatbot</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.chat-box {
    height: 350px;
    overflow-y: auto;
    background: #f8f9fa;
    border-radius: 8px;
    padding: 10px;
    border: 1px solid #ddd;
}
.msg.you { color: #0d6efd; }
.msg.bot { color: #198754; }
</style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-2 bg-dark text-white p-3">
            <h4>HMS Menu</h4>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="#" class="nav-link text-white">Dashboard</a></li>
                <li class="nav-item"><a href="#" class="nav-link text-white">Appointments</a></li>
                <li class="nav-item"><a href="#" class="nav-link text-white">Patients</a></li>
                <li class="nav-item"><a href="#" class="nav-link text-white">Billing</a></li>
                <li class="nav-item"><a href="#" class="nav-link text-white">Lab Reports</a></li>
                <li class="nav-item"><a href="#" class="nav-link text-white fw-bold">Chatbot</a></li>
            </ul>
        </div>

        <!-- Main Chat Section -->
        <div class="col-md-10 p-4">
            <h2 class="mb-4">Hospital Chatbot</h2>
            <div class="chat-box mb-3">
                <?php
                if (empty($_SESSION['chat_history'])) {
                    echo "<div class='msg bot'><strong>HMS Bot:</strong> Hello! How can I help you today?</div>";
                } else {
                    foreach ($_SESSION['chat_history'] as $m) {
                        $class = ($m['sender'] == "You") ? "you" : "bot";
                        echo "<div class='msg {$class}'><strong>{$m['sender']}:</strong> {$m['text']}</div>";
                    }
                }
                ?>
            </div>
            <form method="post" class="d-flex gap-2">
                <input type="text" name="message" class="form-control" placeholder="Type your message..." required>
                <button type="submit" class="btn btn-primary">Send</button>
                <button type="submit" name="clear" value="1" class="btn btn-danger">Clear</button>
            </form>
        </div>
    </div>
</div>
</body>
</html>
