<?php
include 'include/config.php';
session_start();

$message = "";

// ==================
// Handle form submission
// ==================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $doctor_id  = intval($_POST['doctor_id']);
    $day_id     = intval($_POST['day_id']);
    $shift_type = $_POST['shift_type'];
    $start_time = $_POST['start_time'];
    $end_time   = $_POST['end_time'];

    // ✅ Check if doctor already has 5 distinct days
    $checkCount = $con->prepare("SELECT COUNT(DISTINCT day_id) AS total_days FROM doctor_shift_master WHERE doc_id = ?");
    $checkCount->bind_param("i", $doctor_id);
    $checkCount->execute();
    $result = $checkCount->get_result()->fetch_assoc();

    $existingDayCheck = $con->prepare("SELECT id FROM doctor_shift_master WHERE doc_id = ? AND day_id = ?");
    $existingDayCheck->bind_param("ii", $doctor_id, $day_id);
    $existingDayCheck->execute();
    $existingDay = $existingDayCheck->get_result()->num_rows;

    if ($result['total_days'] >= 5 && $existingDay == 0) {
        $message = "❌ Doctor already has 5 available days added!";
    } else {
        // ✅ Prevent duplicate shift type for same doctor + same day
        $checkShift = $con->prepare("SELECT id FROM doctor_shift_master WHERE doc_id = ? AND day_id = ? AND shift_type = ?");
        $checkShift->bind_param("iis", $doctor_id, $day_id, $shift_type);
        $checkShift->execute();
        $shiftExists = $checkShift->get_result()->num_rows;

        if ($shiftExists > 0) {
            $message = "⚠️ This doctor already has a $shift_type shift on this day!";
        } else {
            // ✅ Insert new shift
            $stmt = $con->prepare("INSERT INTO doctor_shift_master (doc_id, day_id, shift_type, start_time, end_time, created) VALUES (?, ?, ?, ?, ?, NOW())");
            $stmt->bind_param("iisss", $doctor_id, $day_id, $shift_type, $start_time, $end_time);

            if ($stmt->execute()) {
                $message = "✅ Doctor $shift_type shift added successfully!";
            } else {
                $message = "❌ Error: " . $con->error;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Doctor | Doctors' Available Timings</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Patient | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
    <!-- ✅ Add this in <head> -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">

                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-3">Add Doctor Availability</h3>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($message)): ?>
                                <div class="alert alert-info"><?= htmlentities($message); ?></div>
                            <?php endif; ?>

                            <!-- ================== Add Availability Form ================== -->
                            <form method="post" action="">
                                <div class="form-group mb-3">
                                    <label for="doctor_id">Select Doctor</label>
                                    <select name="doctor_id" class="form-control" required>
                                        <option value="">-- Select Doctor --</option>
                                        <?php
                                        $result = mysqli_query($con, "SELECT id, doctorName FROM doctors ORDER BY doctorName");
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            echo "<option value='{$row['id']}'>{$row['doctorName']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="day_id">Day</label>
                                    <select name="day_id" class="form-control" required>
                                        <option value="">-- Select Day --</option>
                                        <?php
                                        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
                                        foreach ($days as $key => $day) {
                                            echo "<option value='$key'>$day</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="shift_type">Shift Type</label>
                                    <select name="shift_type" class="form-control" required>
                                        <option value="">-- Select Shift --</option>
                                        <option value="Morning">Morning</option>
                                        <option value="Afternoon">Afternoon</option>
                                        <option value="Evening">Evening</option>
                                        <option value="Night">Night</option>
                                    </select>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="start_time">Start Time</label>
                                    <input type="time" name="start_time" class="form-control" required>
                                </div>

                                <div class="form-group mb-3">
                                    <label for="end_time">End Time</label>
                                    <input type="time" name="end_time" class="form-control" required>
                                </div>

                                <button type="submit" class="btn btn-primary">Add Shift</button>
                            </form>
                        </div>
                    </div>

                    <!-- ================== Show Existing Shifts ================== -->

                    <div class="card shadow mt-4">

                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">Existing Roles</h3>
                        </div>

                        <div class="card-body">
                            <table id="sheduleTable" class="table table-bordered table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Doctor Name</th>
                                        <th>Day</th>
                                        <th>Shift</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = "
                                        SELECT d.doctorName, s.day_id, s.shift_type, s.start_time, s.end_time
                                        FROM doctor_shift_master s
                                        INNER JOIN doctors d ON d.id = s.doc_id
                                        ORDER BY d.doctorName, s.day_id, s.shift_type
                                    ";
                                    $result = mysqli_query($con, $query);
                                    $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
                                    if (mysqli_num_rows($result) > 0) {
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            $dayName = isset($days[$row['day_id']]) ? $days[$row['day_id']] : "N/A";
                                            echo "<tr>
                                        <td>{$row['doctorName']}</td>
                                        <td>$dayName</td>
                                        <td>{$row['shift_type']}</td>
                                        <td>{$row['start_time']}</td>
                                        <td>{$row['end_time']}</td>
                                    </tr>";
                                        }
                                    } else {
                                        echo "<tr><td colspan='5' class='text-center'>No shifts added yet</td></tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>

            </div>

        </div>
    </div>
    </div>
    <!-- JS Libraries -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- ✅ Add these before your custom DataTable script -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.table').DataTable();
        });
    </script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#sheduleTable').DataTable({
                destroy: true,
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "pageLength": 10,
                "lengthMenu": [
                    [5, 10, 25, 50, -1],
                    [5, 10, 25, 50, "All"]
                ],
                "dom": '<"row mb-3"' +
                    '<"col-sm-6 d-flex align-items-center"l>' +
                    '<"col-sm-6 d-flex justify-content-end"f>' +
                    '>' +
                    'rt' +
                    '<"row mt-3"' +
                    '<"col-sm-6"i>' +
                    '<"col-sm-6 d-flex justify-content-end"p>' +
                    '>'
            });
        });
    </script>
</body>

</html>