<?php
session_start();
include('include/config.php');

// ✅ Appointment + Doctor + User join
$sql = "
SELECT 
  a.op_id,
  a.doctorSpecialization,
  a.doctorId,
  a.userId,
  a.appointmentDate,
  a.appointmentTime,
  d.doctorName,
  u.fullName
FROM appointment a
JOIN doctors d ON a.doctorId = d.id
JOIN users u ON a.userId = u.id
";

$result = mysqli_query($con, $sql);

$events = [];
$bookedDates = []; // ✅ store appointment dates
while ($row = mysqli_fetch_assoc($result)) {
    $time = date("H:i:s", strtotime($row['appointmentTime']));
    $events[] = [
        'id'    => $row['op_id'],
        'title' => $row['fullName'], // ✅ Patient name only in title
        'start' => $row['appointmentDate'] . "T" . $time,
        'doctorName' => $row['doctorName'], // extra field
        'appointmentTime' => $time,          // extra field
        'color' => '#28a745'
    ];

    $bookedDates[] = $row['appointmentDate'];
}
$bookedDates = array_unique($bookedDates);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Patient | Appointment Calendar</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <style>
        body {
            background: #f4f6f9;
            font-family: 'Lato', sans-serif;
        }

        #calendar {
            max-width: 100%;
            margin: 20px auto;
            background: #fff;
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        /* Calendar Title */
        .fc-toolbar-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #333;
        }

        /* Buttons */
        .fc-button {
            border-radius: 8px !important;
            padding: 6px 14px !important;
            font-size: 0.9rem;
            font-weight: 500;
            border: none !important;
        }

        .fc-button-primary {
            background: #6f42c1 !important;
            border-color: #6f42c1 !important;
        }

        .fc-button-primary:hover {
            background: #5936a2 !important;
        }

        /* Event Styles */
        .fc-event {
            border-radius: 30px !important;
            font-size: 0.85rem;
            font-weight: 500;
            padding: 4px 8px;
            border: none;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            transition: all 0.2s ease-in-out;
        }

        .fc-event:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        /* Today's highlight */
        .fc-day-today {
            background: #e9f5ff !important;
            border: 1px solid #cfe2ff !important;
        }

        /* Force patient name & time visible in week/day view */
        .fc-timegrid-event .fc-event-title,
        .fc-timegrid-event .fc-event-time {
            color: #000 !important;
            font-weight: 600;
            font-size: 0.85rem;
            white-space: normal !important;
        }

        /* Make sure event text always shows */
        .fc-timegrid-event .fc-event-main {
            color: #fff !important;
            font-weight: 600;
            font-size: 0.9rem;
        }

        /* Remove full-day background highlight */
        .fc-daygrid-day.fc-day-has-event {
            background: transparent !important;
        }

        /* Only highlight the event box */
        .fc-event {
            border-radius: 8px !important;
            font-size: 0.85rem;
            font-weight: 600;
            padding: 6px 10px;
            border: none !important;
            background-color: #6f42c1 !important;
            /* ✅ Primary color */
            color: #fff !important;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .fc-event:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        /* Default buttons */
        .fc .fc-button {
            background-color: #fff !important;
            border: 2px solid #6f42c1 !important;
            /* Primary border */
            color: #6f42c1 !important;
            /* Primary text */
            border-radius: 8px !important;
            padding: 6px 14px !important;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        /* Hover effect */
        .fc .fc-button:hover {
            background-color: #f3e8ff !important;
            /* Light tint of primary */
            color: #6f42c1 !important;
        }

        /* Active button (clicked one) */
        .fc .fc-button.fc-button-active {
            background-color: #6f42c1 !important;
            /* Primary background */
            color: #fff !important;
            /* White text */
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-12">
                                <h1 class="mainTitle">Patient | Appointment Calendar</h1>
                            </div>
                        </div>
                    </section>

                    <!-- ✅ Calendar -->
                    <div id="calendar"></div>

                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- ✅ FullCalendar JS -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
            FormElements.init();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var bookedDates = <?php echo json_encode(array_values($bookedDates)); ?>;

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: <?php echo json_encode($events); ?>,

                eventContent: function(arg) {
                    let patientName = arg.event.title;
                    if (arg.view.type === "dayGridMonth" || arg.view.type === "timeGridWeek" || arg.view.type === "timeGridDay") {
                        return {
                            html: `<b>${patientName}</b>`
                        };
                    }
                },

                eventDidMount: function(info) {
                    let doctorName = info.event.extendedProps.doctorName;
                    let time = info.event.extendedProps.appointmentTime;
                    info.el.setAttribute("title", `Doctor: Dr. ${doctorName}\nTime: ${time}`);
                },

                // ✅ Highlight booked dates
                dayCellDidMount: function(info) {
                    let dateStr = info.date.toISOString().split("T")[0];
                    if (bookedDates.includes(dateStr)) {
                        info.el.style.backgroundColor = "#fff"; // light primary
                        info.el.style.borderRadius = "6px";
                    }
                }
            });

            calendar.render();
        });
    </script>

</body>

</html>