<?php
session_start();
include('include/config.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <title>Admin | Dashboard</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Patient | Reports</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
  <style>
    /* Gradient card style */
    .gradient-card {
      color: #fff;
      border-radius: 1rem;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
      transition: transform 0.2s ease-in-out;
    }

    .gradient-card:hover {
      transform: scale(1.05);
    }

    .gradient-blue {
      background: linear-gradient(135deg, #667eea, #764ba2);
    }

    .gradient-green {
      background: linear-gradient(135deg, #56ab2f, #a8e063);
    }

    .gradient-orange {
      background: linear-gradient(135deg, #ff512f, #dd2476);
    }

    .gradient-yellow {
      background: linear-gradient(135deg, #f7971e, #ffd200);
    }

    .gradient-card .icon {
      font-size: 2.5rem;
      opacity: 0.8;
    }
  </style>
</head>

<body>
  <div class="container-scroller">
    <?php include('include/sidebar.php'); ?>

    <div class="container-fluid page-body-wrapper">
      <?php include('include/header.php'); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <section id="page-title">
            <div class="row mb-4">
              <div class="col-sm-12">
                <h1 class="mainTitle text-primary fw-bold">Admin Dashboard</h1>
                <p class="text-muted">Quick stats & overview of your hospital system</p>
              </div>
            </div>
          </section>

          <!-- Gradient Cards -->
          <div class="row g-4">
            <!-- Appointments -->
            <div class="col-md-4">
              <div class="card gradient-blue gradient-card h-100 p-4">
                <div class="d-flex justify-content-between align-items-center">
                  <div>
                    <h5 class="fw-bold">Appointments</h5>
                    <p class="mb-1">Total Appointments</p>
                    <h3 class="fw-bold">
                      <?php
                      $sql = mysqli_query($con, "SELECT * FROM appointment");
                      echo htmlentities(mysqli_num_rows($sql));
                      ?>
                    </h3>
                    <a href="appointment-history.php" class="btn btn-sm btn-light mt-2">View Details</a>
                  </div>
                  <i class="fa fa-calendar-check-o icon"></i>
                </div>
              </div>
            </div>

            <!-- Doctors -->
            <div class="col-md-4">
              <div class="card gradient-green gradient-card h-100 p-4">
                <div class="d-flex justify-content-between align-items-center">
                  <div>
                    <h5 class="fw-bold">Doctors</h5>
                    <p class="mb-1">Total Registered Doctors</p>
                    <h3 class="fw-bold">
                      <?php
                      $result1 = mysqli_query($con, "SELECT * FROM doctors ");
                      echo htmlentities(mysqli_num_rows($result1));
                      ?>
                    </h3>
                    <a href="manage-doctors.php" class="btn btn-sm btn-light mt-2">Manage Doctors</a>
                  </div>
                  <i class="fa fa-user-md icon"></i>
                </div>
              </div>
            </div>

            <!-- Users -->
            <div class="col-md-4">
              <div class="card gradient-orange gradient-card h-100 p-4">
                <div class="d-flex justify-content-between align-items-center">
                  <div>
                    <h5 class="fw-bold">Users</h5>
                    <p class="mb-1">System Registered Users</p>
                    <h3 class="fw-bold">
                      <?php
                      $r = mysqli_query($con, "SELECT count(*) FROM users");
                      echo htmlentities(mysqli_fetch_array($r)[0]);
                      ?>
                    </h3>
                    <a href="manage-users.php" class="btn btn-sm btn-light mt-2">Manage Users</a>
                  </div>
                  <i class="fa fa-users icon"></i>
                </div>
              </div>
            </div>
          </div>

          
        </div>

        <?php include('include/footer.php'); ?>
      </div>
    </div>
  </div>

  <!-- Scripts -->
  <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <script src="assets/vendors/chart.js/Chart.min.js"></script>
  <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
  <script src="assets/vendors/flot/jquery.flot.js"></script>
  <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
  <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
  <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
  <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
  <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
  <script src="assets/js/off-canvas.js"></script>
  <script src="assets/js/hoverable-collapse.js"></script>
  <script src="assets/js/misc.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
</body>

</html>