<?php
session_start();
include "include/config.php";

$id = $_GET['id'] ?? 0;
if (!$id) {
    header("Location: user_master.php");
    exit;
}

$message = "";

// Fetch roles for dropdown
$roles = $con->query("SELECT id, role_name FROM role_master WHERE status=1 ORDER BY role_name ASC");

// Fetch user details
$stmt = $con->prepare("SELECT * FROM user_master WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$user = $res->fetch_assoc();
$stmt->close();

if (!$user) {
    header("Location: user_master.php");
    exit;
}

// Handle form submission
if (isset($_POST['submit'])) {
    $username = trim($_POST['username']);
    $role_id = $_POST['role_id'];
    $status = $_POST['status'];
    $modified_by = $_SESSION['id'] ?? 0;
    $modified_on = date("Y-m-d H:i:s");

    // Update password only if entered
    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $con->prepare("UPDATE user_master SET username=?, role_id=?, password=?, status=?, modified_by=?, modified_on=? WHERE id=?");
        $stmt->bind_param("sisissi", $username, $role_id, $password, $status, $modified_by, $modified_on, $id);
    } else {
        $stmt = $con->prepare("UPDATE user_master SET username=?, role_id=?, status=?, modified_by=?, modified_on=? WHERE id=?");
        $stmt->bind_param("sisisi", $username, $role_id, $status, $modified_by, $modified_on, $id);
    }

    if ($stmt->execute()) {
        $message = "User updated successfully!";
        header("Location: user_master.php");
    } else {
        $message = "Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Edit User</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card shadow p-4">
                        <h2 class="mb-3">Edit User</h2>

                        <?php if ($message): ?>
                            <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?>"><?= $message ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">User Name *</label>
                                <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Role *</label>
                                <select name="role_id" class="form-select" required>
                                    <option value="">-- Select Role --</option>
                                    <?php while ($role = $roles->fetch_assoc()): ?>
                                        <option value="<?= $role['id'] ?>" <?= $role['id'] == $user['role_id'] ? 'selected' : '' ?>><?= htmlspecialchars($role['role_name']) ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Password (leave blank to keep unchanged)</label>
                                <input type="password" name="password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="1" <?= $user['status'] ? 'selected' : '' ?>>Active</option>
                                    <option value="0" <?= !$user['status'] ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>

                            <button type="submit" name="submit" class="btn btn-primary">Update User</button>
                            <a href="user_master.php" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</body>

</html>