<?php
session_start();
include('include/config.php');

// Fetch all users from the database
$allPatients = [];
$query = "SELECT * FROM users ORDER BY id DESC";
$result = mysqli_query($con, $query);
while ($row = mysqli_fetch_assoc($result)) {
    $allPatients[] = $row;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage Patients</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>

<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Reception | Manage Patients</h1>
                        </div>
                    </div>
                </section>

                <div class="container mt-4">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Full Name</th>
                                <th>Address</th>
                                <th>City</th>
                                <th>Gender</th>
                                <!-- <th>Username</th>
                                <th>Password</th> -->
                                <!-- Optional columns you can enable:
                                <th>Age</th>
                                <th>Blood Group</th>
                                <th>Country</th>
                                <th>Pincode</th>
                                <th>Reg Date</th>
                                <th>Updated On</th>
                                -->
                                <!-- <th>Actions</th> -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($allPatients as $row): ?>
                                <tr>
                                    <td><?= htmlentities($row['id']) ?></td>
                                    <td><?= htmlentities($row['fullName']) ?></td>
                                    <td><?= htmlentities($row['address']) ?></td>
                                    <td><?= htmlentities($row['city']) ?></td>
                                    <td><?= htmlentities($row['gender']) ?></td>
                                    <!-- <td><?= htmlentities($row['username']) ?></td>
                                    <td><?= htmlentities($row['password']) ?></td> -->
                                    <!-- Optional data columns
                                    <td><?= htmlentities($row['age']) ?></td>
                                    <td><?= htmlentities($row['bloodgroup']) ?></td>
                                    <td><?= htmlentities($row['country']) ?></td>
                                    <td><?= htmlentities($row['pincode']) ?></td>
                                    <td><?= htmlentities($row['regDate']) ?></td>
                                    <td><?= htmlentities($row['updationDate']) ?></td>
                                    -->
                                    <!-- Actions (Edit/View/Delete) -->
                                    
                                    <td>
                                        <a href="edit-patient.php?editid=<?= $row['id']; ?>" class="btn btn-sm btn-warning"><i class="fa fa-pencil"></i></a>
                                        <a href="view-patient.php?viewid=<?= $row['id']; ?>" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a>
                                        <a href="manage-patient.php?delid=<?= $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this patient?');"><i class="fa fa-trash"></i></a>
                                    </td>
                                   
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php if (empty($allPatients)): ?>
                        <div class="alert alert-info">No patient records found.</div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
</div>
</body>
</html>
