<?php
session_start();
include "include/config.php";

$message = "";

// Handle form submission
if (isset($_POST['submit'])) {
    $username = trim($_POST['username']);
    $role_id = intval($_POST['role_id']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $status = intval($_POST['status']);
    $created_by = $_SESSION['id'] ?? 0;
    $created_on = date("Y-m-d H:i:s");

    // 1️⃣ Get the selected role's allowed user count and company name
    $roleCheck = $con->prepare("SELECT company_name, users_allow FROM role_master WHERE id = ?");
    $roleCheck->bind_param("i", $role_id);
    $roleCheck->execute();
    $roleCheck->bind_result($company_name, $users_allow);
    $roleCheck->fetch();
    $roleCheck->close();

    if (!$company_name) {
        $message = "Invalid Role Selection!";
    } else {
        // 2️⃣ Count how many users already exist for this company
        $countStmt = $con->prepare("
            SELECT COUNT(*) 
            FROM user_master u 
            JOIN role_master r ON u.role_id = r.id 
            WHERE r.company_name = ?
        ");
        $countStmt->bind_param("s", $company_name);
        $countStmt->execute();
        $countStmt->bind_result($current_users);
        $countStmt->fetch();
        $countStmt->close();

        // 3️⃣ Check if limit reached
        if ($current_users >= $users_allow) {
            $message = "❌ User limit reached for <b>$company_name</b>! (Allowed: $users_allow)";
        } else {
            // 4️⃣ Insert user as usual
            $stmt = $con->prepare("INSERT INTO user_master (username, role_id, password, status, created_by, created_on)
                                   VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sisiis", $username, $role_id, $password, $status, $created_by, $created_on);

            if ($stmt->execute()) {
                $message = "✅ User added successfully for $company_name!";
            } else {
                $message = "Error: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// Fetch roles for dropdown
$roles = $con->query("SELECT id, role_name FROM role_master WHERE status=1 ORDER BY role_name ASC");

// Fetch users for table
$users = $con->query("SELECT u.id, u.username, r.role_name, r.company_name, u.status, u.created_on, u.created_by 
                      FROM user_master u 
                      JOIN role_master r ON u.role_id = r.id 
                      ORDER BY u.id DESC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage Users</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h3>Add New User</h3>
                        </div>
                        <div class="card-body">
                            <?php if ($message): ?>
                                <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?>"><?= $message ?></div>
                            <?php endif; ?>

                            <form method="post">
                                <div class="mb-3">
                                    <label class="form-label">User Name *</label>
                                    <input type="text" name="username" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Role *</label>
                                    <select name="role_id" class="form-select" required>
                                        <option value="">-- Select Role --</option>
                                        <?php while ($role = $roles->fetch_assoc()): ?>
                                            <option value="<?= $role['id'] ?>"><?= htmlspecialchars($role['role_name']) ?></option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Password *</label>
                                    <input type="password" name="password" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-select">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>

                                <button type="submit" name="submit" class="btn btn-primary">Add User</button>
                            </form>
                        </div>
                    </div>

                    <div class="card shadow mt-4">
                        <div class="card-header bg-primary text-white">
                            <h3>Manage Users</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Company</th>
                                        <th>Username</th>
                                        <th>Role</th>
                                        <th>Status</th>
                                        <th>Created By</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 1;
                                    while ($user = $users->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= $i++ ?></td>
                                            <td><?= htmlspecialchars($user['company_name']) ?></td>
                                            <td><?= htmlspecialchars($user['username']) ?></td>
                                            <td><?= htmlspecialchars($user['role_name']) ?></td>
                                            <td><?= $user['status'] ? 'Active' : 'Inactive' ?></td>
                                            <td><?= $user['created_by'] ?></td>
                                            <td><?= $user['created_on'] ?></td>
                                            <td>
                                                <a href="edit_user.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                                <a href="delete_user.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>
</body>
<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<!-- endinject -->
<!-- Plugin js for this page -->
<script src="assets/vendors/chart.js/Chart.min.js"></script>
<script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="assets/vendors/flot/jquery.flot.js"></script>
<script src="assets/vendors/flot/jquery.flot.resize.js"></script>
<script src="assets/vendors/flot/jquery.flot.categories.js"></script>
<script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
<script src="assets/vendors/flot/jquery.flot.stack.js"></script>
<script src="assets/vendors/flot/jquery.flot.pie.js"></script>
<!-- End plugin js for this page -->
<!-- inject:js -->
<script src="assets/js/off-canvas.js"></script>
<script src="assets/js/hoverable-collapse.js"></script>
<script src="assets/js/misc.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
        FormElements.init();
    });
</script>
<script>
    // Initialize Select2 on the patient dropdown
    $(document).ready(function() {
        $('#patientSelect').select2({
            placeholder: "Search Patient Name",
            allowClear: true
        });
    });
</script>

</html>