<?php
session_start();
include('include/config.php');
error_reporting(0);

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<script>alert('Invalid patient ID'); window.location.href='manage-patient.php';</script>";
    exit();
}

$id = intval($_GET['id']);

// Get existing patient data
$patient = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM in_patient WHERE id = '$id'"));
if (!$patient) {
    echo "<script>alert('Patient not found.'); window.location.href='manage-patient.php';</script>";
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullName = $_POST['fullName'];
    $Doctorspecialization = $_POST['Doctorspecialization'];
    $patcontact = $_POST['patcontact'];
    $patemail = $_POST['patemail'];
    $gender = $_POST['gender'];
    $pataddress = $_POST['pataddress'];
    $state = $_POST['state'];
    $city = $_POST['city'];

    $update = mysqli_query($con, "
        UPDATE in_patient SET 
            fullName = '$fullName',
            Doctorspecialization = '$Doctorspecialization',
            patcontact = '$patcontact',
            patemail = '$patemail',
            gender = '$gender',
            pataddress = '$pataddress',
            state = '$state',
            city = '$city'
        WHERE id = '$id'
    ");

    if ($update) {
        echo "<script>alert('Patient updated successfully.'); window.location.href='manage-patient.php';</script>";
        exit();
    } else {
        echo "<script>alert('Failed to update patient.');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit In-Patient</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- Page Title -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Reception | Edit Patient Details</h1>
                        </div>
                    </div>
                </section>

                <!-- Edit Form -->
                <div class="container mt-4">
                    <form method="post" action="">
                        <div class="form-group">
                            <label>Select Patient Name:</label>
                            <select name="fullName" class="form-control" required>
                                <option value="">-- Select patient --</option>
                                <?php
                                $result = mysqli_query($con, "SELECT fullName FROM users ORDER BY fullName");
                                while ($row = mysqli_fetch_assoc($result)) {
                                    $selected = ($row['fullName'] == $patient['fullName']) ? 'selected' : '';
                                    echo "<option value='".htmlentities($row['fullName'])."' $selected>".htmlentities($row['fullName'])."</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Doctor Specialization:</label>
                            <input type="text" name="Doctorspecialization" class="form-control" value="<?= htmlentities($patient['Doctorspecialization']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label>Contact:</label>
                            <input type="text" name="patcontact" class="form-control" value="<?= htmlentities($patient['patcontact']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label>Email:</label>
                            <input type="email" name="patemail" class="form-control" value="<?= htmlentities($patient['patemail']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label>Gender:</label>
                            <select name="gender" class="form-control" required>
                                <option value="Male" <?= $patient['gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
                                <option value="Female" <?= $patient['gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
                                <option value="Other" <?= $patient['gender'] == 'Other' ? 'selected' : '' ?>>Other</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Address:</label>
                            <textarea name="pataddress" class="form-control" required><?= htmlentities($patient['pataddress']) ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>State:</label>
                            <input type="text" name="state" class="form-control" value="<?= htmlentities($patient['state']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label>City:</label>
                            <input type="text" name="city" class="form-control" value="<?= htmlentities($patient['city']) ?>" required>
                        </div>

                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="manage-patient.php" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
</body>
</html>
