<?php
session_start();
error_reporting(0);
include('include/config.php');

// Validate ID
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    $_SESSION['msg'] = "Invalid Daily Round ID.";
    header("Location: view_dailyround.php");
    exit;
}

// Fetch record
$round = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM daily_rounds WHERE id='$id'"));
if (!$round) {
    $_SESSION['msg'] = "Daily Round not found.";
    header("Location: view_dailyround.php");
    exit;
}

// Update on submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $fullName       = $_POST['fullName'];
    $doctorName     = $_POST['doctorName'];
    $round_date     = $_POST['round_date'];
    $clinical_notes = $_POST['clinical_notes'];
    $investigations = $_POST['investigations'];
    $treatment_plan = $_POST['treatment_plan'];

    $stmt = mysqli_prepare($con, "UPDATE daily_rounds SET 
        fullName=?, 
        doctorName=?, 
        round_date=?, 
        clinical_notes=?, 
        investigations=?, 
        treatment_plan=? 
        WHERE id=?");

    mysqli_stmt_bind_param($stmt, 'ssssssi', 
        $fullName, $doctorName, $round_date, 
        $clinical_notes, $investigations, $treatment_plan, $id);

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['msg'] = "Daily Round updated successfully.";
    } else {
        $_SESSION['msg'] = "Error updating Daily Round.";
    }
    mysqli_stmt_close($stmt);

    header("Location: edit_dailyround.php?id=$id");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Daily Round</title>
    <meta charset="UTF-8">
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,600,700|Raleway:400,500,600|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Edit Daily Round</h1>
                        </div>
                    </div>
                </section>

                <!-- MESSAGE -->
                <?php
                if (isset($_SESSION['msg'])) {
                    echo '<div class="alert alert-info">'.htmlentities($_SESSION['msg']).'</div>';
                    unset($_SESSION['msg']);
                }
                ?>

                <!-- FORM -->
                <div class="container-fluid container-fullw bg-white">
                    <form method="post">
                        <div class="form-group">
                            <label>Select Patient</label>
                            <select name="fullName" class="form-control" required>
                                <option value="">-- Select Patient --</option>
                                <?php
                                $res = mysqli_query($con, "SELECT fullName FROM users ORDER BY fullName");
                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($row['fullName'] == $round['fullName']) ? 'selected' : '';
                                    echo "<option value='{$row['fullName']}' $selected>{$row['fullName']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Select Doctor</label>
                            <select name="doctorName" class="form-control" required>
                                <option value="">-- Select Doctor --</option>
                                <?php
                                $res = mysqli_query($con, "SELECT doctorName FROM doctors ORDER BY doctorName");
                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($row['doctorName'] == $round['doctorName']) ? 'selected' : '';
                                    echo "<option value='{$row['doctorName']}' $selected>{$row['doctorName']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Round Date</label>
                            <input type="date" name="round_date" class="form-control" 
                                   value="<?= htmlentities($round['round_date']); ?>" required>
                        </div>

                        <div class="form-group">
                            <label>Clinical Notes</label>
                            <textarea name="clinical_notes" class="form-control" rows="3" required><?= htmlentities($round['clinical_notes']); ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>Investigations</label>
                            <textarea name="investigations" class="form-control" rows="3"><?= htmlentities($round['investigations']); ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>Treatment Plan</label>
                            <textarea name="treatment_plan" class="form-control" rows="3"><?= htmlentities($round['treatment_plan']); ?></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary">Update Entry</button>
                        <a href="view_dailyround.php" class="btn btn-secondary">Back</a>
                    </form>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
