<?php
session_start();
error_reporting(0);
include('include/config.php');

// Handle delete request
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);
    $del_stmt = mysqli_prepare($con, "DELETE FROM daily_rounds WHERE id = ?");
    mysqli_stmt_bind_param($del_stmt, 'i', $delid);
    if (mysqli_stmt_execute($del_stmt)) {
        $_SESSION['msg'] = "Daily round entry deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting entry.";
    }
    mysqli_stmt_close($del_stmt);
    header("Location: view_dailyround.php"); // Prevent re-execution on refresh
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Doctor | View Daily Rounds</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,600,700|Raleway:300,400,500,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | View Daily Rounds</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="dailyRoundsTable">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Patient Name</th>
                                        <th>Doctor</th>
                                        <th>Round Date</th>
                                        <th>Clinical Notes</th>
                                        <th>Investigations</th>
                                        <th>Treatment Plan</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $query = mysqli_query($con, "SELECT * FROM daily_rounds ORDER BY round_date DESC");
                                $cnt = 1;
                                while ($row = mysqli_fetch_array($query)) {
                                ?>
                                    <tr>
                                        <td><?php echo $cnt++; ?></td>
                                        <td><?php echo htmlentities($row['fullName']); ?></td>
                                        <td><?php echo htmlentities($row['doctorName']); ?></td>
                                        <td><?php echo htmlentities($row['round_date']); ?></td>
                                        <td><?php echo htmlentities($row['clinical_notes']); ?></td>
                                        <td><?php echo htmlentities($row['investigations']); ?></td>
                                        <td><?php echo htmlentities($row['treatment_plan']); ?></td>
                                        <td>
                                            <a href="edit_dailyround.php?id=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Edit"><i class="fa fa-pencil"></i></a>
                                            <a href="view_dailyround.php?delid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Delete" onclick="return confirm('Are you sure you want to delete this entry?');">
                                                <i class="fa fa-trash" style="color:red;"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        $('#dailyRoundsTable').DataTable();
    });
</script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
