<?php
session_start();
error_reporting(0);
include('include/config.php');

// ----------------- DELETE HANDLER (prepared) -----------------
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);
    if ($delid > 0) {
        $del_stmt = mysqli_prepare($con, "DELETE FROM discharge_summaries WHERE id = ?");
        mysqli_stmt_bind_param($del_stmt, 'i', $delid);
        if (mysqli_stmt_execute($del_stmt)) {
            $_SESSION['msg'] = "Discharge summary deleted successfully.";
        } else {
            $_SESSION['msg'] = "Error deleting discharge summary.";
        }
        mysqli_stmt_close($del_stmt);
    }
    // Redirect to avoid duplicate action on refresh
    header("Location: view_discharge_summary.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Manage Discharge Summaries</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>

    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- start: PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Manage Discharge Summaries</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">'.htmlentities($_SESSION['msg']).'</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="example1">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Patient Name</th>
                                    <th>Admission Date</th>
                                    <th>Discharge Date</th>
                                    <th>Diagnosis</th>
                                    <th>Treatment Given</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                // You can filter/order as needed; keeping simple and consistent with your pages
                                $res = mysqli_query($con, "SELECT id, fullName, admission_date, discharge_date, diagnosis, treatment_given FROM discharge_summaries ORDER BY id DESC");
                                $cnt = 1;
                                while ($row = mysqli_fetch_assoc($res)) {
                                ?>
                                    <tr>
                                        <td><?= $cnt++; ?>.</td>
                                        <td><?= htmlentities($row['fullName']); ?></td>
                                        <td><?= htmlentities($row['admission_date']); ?></td>
                                        <td><?= htmlentities($row['discharge_date']); ?></td>
                                        <td><?= htmlentities($row['diagnosis']); ?></td>
                                        <td><?= htmlentities($row['treatment_given']); ?></td>
                                        <td>
                                            <a href="view-summary.php?id=<?= $row['id']; ?>" title="View">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            &nbsp;&nbsp;
                                            <a href="edit-summary.php?editid=<?= $row['id']; ?>" title="Edit">
                                                <i class="fa fa-pencil" style="color:#007bff;"></i>
                                            </a>
                                            &nbsp;&nbsp;
                                            <a href="view_discharge_summary.php?delid=<?= $row['id']; ?>"
                                               title="Delete"
                                               onclick="return confirm('Are you sure you want to delete this record?');">
                                                <i class="fa fa-trash" style="color:red;"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div><!-- end app-content -->

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>

</div><!-- end app -->

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        $('#example1').DataTable();
    });
</script>

<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
    });
</script>
</body>
</html>
