<?php
include('include/config.php');

if (!isset($_GET['pid']) || empty($_GET['pid'])) {
    die("Invalid request");
}

$pid = intval($_GET['pid']);

// JOIN query to fetch prescription and items
$query = "
SELECT p.pname, p.diagnosis, p.prescription, p.notes, p.pid,
       pi.medicine_name, pi.dosage, pi.duration
FROM prescriptions p
LEFT JOIN prescription_items pi ON p.pid = pi.pid
WHERE p.pid = '$pid'";

$result = mysqli_query($con, $query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Add Patient Prescription</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
    <link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Add Prescription</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Patient</span></li>
                            <li class="active"><span>Add Patient</span></li>
                        </ol> -->
                    </div>
                </section>

                <div class="text-end mb-3">
                    <button onclick="printSection('print-area')" class="btn btn-primary">
                        <i class="ti-printer"></i> Print
                    </button>
                </div>
                
                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row margin-top-30">
                                <div class="col-lg-12 col-md-12">

                                    <div id="print-area" class="container mt-4">
                                        <h3>Prescription Details</h3>
                                        <table class="table table-bordered">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Patient Name</th>
                                                    <th>Diagnosis</th>
                                                    <th>Prescription</th>
                                                    <th>Notes</th>
                                                    <th>Medicine</th>
                                                    <th>Dosage</th>
                                                    <th>Duration</th>
                                                </tr>
                                            </thead>
											<tbody>
<?php
$shown = false; // Flag to show patient data only once

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";

        if (!$shown) {
            echo "<td>" . htmlspecialchars($row['pname']) . "</td>";
            echo "<td>" . htmlspecialchars($row['diagnosis']) . "</td>";
            echo "<td>" . htmlspecialchars($row['prescription']) . "</td>";
            echo "<td>" . htmlspecialchars($row['notes']) . "</td>";
            $shown = true;
        } else {
            echo "<td></td><td></td><td></td><td></td>";
        }

        echo "<td>" . htmlspecialchars($row['medicine_name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['dosage']) . "</td>";
        echo "<td>" . htmlspecialchars($row['duration']) . "</td>";

        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='7' class='text-center'>No prescription found for this ID.</td></tr>";
}
?>
</tbody>

                                        </table>
                                        <a href="view-prescription.php" class="btn btn-secondary">Back</a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12">
                    <div class="panel panel-white"></div>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="vendor/autosize/autosize.min.js"></script>
<script src="vendor/selectFx/classie.js"></script>
<script src="vendor/selectFx/selectFx.js"></script>
<script src="vendor/select2/select2.min.js"></script>
<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/form-elements.js"></script>

<script>
    jQuery(document).ready(function () {
        Main.init();
        FormElements.init();
    });

    function printSection(divId) {
        var printContents = document.getElementById(divId).innerHTML;
        var win = window.open('', '', 'height=700,width=900');
        win.document.write('<html><head><title>Print</title>');
        win.document.write('<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">');
        win.document.write('<style>table{width:100%;border-collapse:collapse}th,td{border:1px solid #000;padding:8px;text-align:left;}</style>');
        win.document.write('</head><body>');
        win.document.write(printContents);
        win.document.write('</body></html>');
        win.document.close();
        win.print();
    }
</script>
</body>
</html>
