<?php
session_start();
error_reporting(0);
include('include/config.php');

// Handle delete request
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);
    $del_stmt = mysqli_prepare($con, "DELETE FROM lab_report WHERE id = ?");
    mysqli_stmt_bind_param($del_stmt, 'i', $delid);
    if (mysqli_stmt_execute($del_stmt)) {
        $_SESSION['msg'] = "Lab report deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting lab report.";
    }
    mysqli_stmt_close($del_stmt);
    header("Location: view_reports.php"); // Prevent re-execution on page refresh
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Doctor | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="wrap-content container" id="container">

                        <!-- PAGE TITLE -->
                        <section id="page-title">
                            <div class="row">
                                <div class="col-sm-8">
                                    <h1 class="mainTitle">Lab | View Lab Reports</h1>
                                </div>
                            </div>
                        </section>

                        <div class="container-fluid container-fullw bg-white">
                            <?php
                            if (isset($_SESSION['msg'])) {
                                echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                                unset($_SESSION['msg']);
                            }
                            ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-striped table-bordered" id="example1">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Patient Name</th>
                                                <th>Result</th>
                                                <th>Report Date</th>
                                                <th>Doctor Name</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query = mysqli_query($con, "SELECT * FROM lab_report ORDER BY report_date DESC");
                                            $cnt = 1;
                                            while ($row = mysqli_fetch_array($query)) {
                                            ?>
                                                <tr>
                                                    <td><?php echo $cnt++; ?></td>
                                                    <td><?php echo htmlentities($row['fullName']); ?></td>
                                                    <td><?php echo htmlentities($row['result']); ?></td>
                                                    <td><?php echo htmlentities($row['report_date']); ?></td>
                                                    <td><?php echo htmlentities($row['doctorName']); ?></td>
                                                    <td>
                                                        <a href="edit_lab.php?id=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Edit"><i class="fa fa-pencil"></i></a>
                                                        <a href="view_reports.php?delid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Delete" onclick="return confirm('Are you sure you want to delete this report?');">
                                                            <i class="fa fa-trash" style="color:red;"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS -->
   <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <!-- endinject -->
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#example1').DataTable();
        });
    </script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
</body>

</html>