<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

// helper function for safe htmlentities
function e($value)
{
    return htmlentities($value ?? '', ENT_QUOTES, 'UTF-8');
}
// =====================
// ACCEPT OR CANCEL APPOINTMENT
// =====================
if (isset($_GET['action']) && isset($_GET['id'])) {
    $appointmentId = intval($_GET['id']);
    $action = $_GET['action'];

    if ($action == "accept") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 2 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment accepted successfully!";
    }

    if ($action == "cancel") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 0 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment cancelled successfully!";
    }

    header("Location: appointment-history.php");
    exit();
}

// =====================
// DATE FILTER
// =====================
$from_date = !empty($_POST['from_date']) ? $_POST['from_date'] : '';
$to_date   = !empty($_POST['to_date']) ? $_POST['to_date'] : '';
$dateFilter = ($from_date && $to_date) ? " AND DATE(a.appointmentDate) BETWEEN '$from_date' AND '$to_date'" : "";

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Admin | All Appointments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<style>

</style>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card shadow mt-4">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">All Appointments</h3>
                        </div>


                        <!-- Appointment Table -->
                        <div class="card-body">
                            <?php
                            if (isset($_SESSION['msg'])) {
                                echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                                unset($_SESSION['msg']);
                            }
                            ?>
                            <form method="post" class="form-inline mt-3">
                                <label class="mr-2">From:</label>
                                <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                                <label class="mr-2">To:</label>
                                <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                                <button type="submit" class="btn btn-primary">Filter</button>
                                <a href="appointment-history.php" class="btn btn-danger ml-2">Reset</a>
                            </form>
                            <table id="appointmentTable" class="table table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Patient Name</th>
                                        <th>Doctor Name</th>
                                        <th>Reason</th>
                                        <th>Date & Time</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = mysqli_query($con, "
                                    SELECT a.*, 
                                           u.fullName AS patientName, u.mobile_no, u.email, 
                                           u.address, u.city, u.pincode, u.age, a.reason,
                                           d.doctorName
                                    FROM appointment a
                                    JOIN users u ON u.id = a.userId 
                                    JOIN doctors d ON d.id = a.doctorId
                                    WHERE doctorStatus=2
                                    ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                                ");

                                    if (mysqli_num_rows($query) == 0) {
                                        echo "<tr><td colspan='6' class='text-center text-danger'>No appointments found.</td></tr>";
                                    } else {
                                        while ($row = mysqli_fetch_assoc($query)) {
                                            if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) $status = "⏳ Pending";
                                            elseif ($row['userStatus'] == 0 && $row['doctorStatus'] == 1) $status = "❌ Cancelled by Patient";
                                            elseif ($row['doctorStatus'] == 0) $status = "❌ Cancelled by Front office";
                                            elseif ($row['doctorStatus'] == 2) $status = "✅ Accepted by Front office";
                                            else $status = "❌ Cancelled";

                                            echo "<tr>
                                                        <td>" . e($row['patientName']) . "</td>
                                                        <td>" . e($row['doctorName']) . "</td>
                                                        <td>" . e($row['reason']) . "</td>
                                                        <td>" . e($row['appointmentDate']) . " " . e($row['appointmentTime']) . "</td>
                                                        <td>" . e($status) . "</td>
                                                        <td>";



                                            echo " 
                                                    <button
                                                        class='btn btn-info btn-sm view-details'
                                                        data-toggle='modal'
                                                        data-target='#detailsModal'
                                                        data-patientid='" . $row['userId'] . "'
                                                        data-patient='" . e($row['patientName']) . "'
                                                        data-doctor='" . e($row['doctorName']) . "'
                                                        data-email='" . e($row['email']) . "'
                                                        data-mobile='" . e($row['mobile_no']) . "'
                                                        data-address='" . e($row['address']) . "'
                                                        data-city='" . e($row['city']) . "'
                                                        data-pincode='" . e($row['pincode']) . "'
                                                        data-age='" . e($row['age']) . "'
                                                        data-reason='" . e($row['reason']) . "'
                                                        data-date='" . e($row['appointmentDate']) . "'
                                                        data-time='" . e($row['appointmentTime']) . "'
                                                        data-status='" . e($status) . "'
                                                    >
                                                        View
                                                    </button>
                                                    <a href='patient_vitals.php?patient_id=" . $row['userId'] . "' class='btn btn-success btn-sm ml-2'>
                                                    Vitals
                                                </a>
                                                </td></tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Date Filter -->



                    <!-- Details Modal -->
                    <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Appointment & Prescription Details</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <h5>Appointment Info</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Patient Name</th>
                                            <td id="dPatient"></td>
                                        </tr>
                                        <tr>
                                            <th>Doctor Name</th>
                                            <td id="dDoctor"></td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td id="dEmail"></td>
                                        </tr>
                                        <tr>
                                            <th>Mobile</th>
                                            <td id="dMobile"></td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td id="dAddress"></td>
                                        </tr>
                                        <tr>
                                            <th>City</th>
                                            <td id="dCity"></td>
                                        </tr>
                                        <tr>
                                            <th>Pincode</th>
                                            <td id="dPincode"></td>
                                        </tr>
                                        <tr>
                                            <th>Age</th>
                                            <td id="dAge"></td>
                                        </tr>
                                        <tr>
                                            <th>Reason</th>
                                            <td id="dReason"></td>
                                        </tr>
                                        <tr>
                                            <th>Date</th>
                                            <td id="dDate"></td>
                                        </tr>
                                        <tr>
                                            <th>Time</th>
                                            <td id="dTime"></td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td id="dStatus"></td>
                                        </tr>
                                    </table>

                                    <h5 class="mt-4">Prescription Info</h5>
                                    <div id="prescriptionDetails">Loading...</div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS Libraries -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            // DataTable initialization
            $('#appointmentTable').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "pageLength": 10,
                "lengthMenu": [
                    [5, 10, 25, 50, -1],
                    [5, 10, 25, 50, "All"]
                ],
                "dom": '<"row mb-3"' +
                    '<"col-sm-6 d-flex align-items-center"l>' +
                    '<"col-sm-6 d-flex justify-content-end"f>' +
                    '>' +
                    'rt' +
                    '<"row mt-3"' +
                    '<"col-sm-6"i>' +
                    '<"col-sm-6 d-flex justify-content-end"p>' +
                    '>'
            });

            // 👉 View details click handler
            $(document).on("click", ".view-details", function() {
                $("#dPatient").text($(this).data("patient"));
                $("#dDoctor").text($(this).data("doctor"));
                $("#dEmail").text($(this).data("email"));
                $("#dMobile").text($(this).data("mobile"));
                $("#dAddress").text($(this).data("address"));
                $("#dCity").text($(this).data("city"));
                $("#dPincode").text($(this).data("pincode"));
                $("#dAge").text($(this).data("age"));
                $("#dReason").text($(this).data("reason"));
                $("#dDate").text($(this).data("date"));
                $("#dTime").text($(this).data("time"));
                $("#dStatus").text($(this).data("status"));

                // Prescription Ajax load (if you have prescription details in DB)
                var patientId = $(this).data("patientid");
                $("#prescriptionDetails").html("Loading...");
                $.ajax({
                    url: "get-prescription.php", // <-- create this PHP file
                    method: "POST",
                    data: {
                        patient_id: patientId
                    },
                    success: function(data) {
                        $("#prescriptionDetails").html(data);
                    },
                    error: function() {
                        $("#prescriptionDetails").html("<span class='text-danger'>No prescription found.</span>");
                    }
                });
            });
        });
    </script>

</body>

</html>