<?php
session_start();
error_reporting(0);
include("include/config.php");

if (isset($_POST['submit'])) {
  $puname = trim($_POST['username']);
  $ppwd = trim($_POST['password']);

  if (!empty($puname) && !empty($ppwd)) {

    // Check if the user exists and role is ROLE-006 with status 1
    $stmt = $con->prepare("
      SELECT u.*, r.code, r.status as role_status 
      FROM user_master u 
      JOIN role_master r ON u.role_id = r.id 
      WHERE u.username = ? AND r.code = 'ROLE-003' AND r.status = 1
  ");
    $stmt->bind_param("s", $puname);
    $stmt->execute();
    $result = $stmt->get_result();

    // If user exists
    if ($result->num_rows > 0) {
      $user = $result->fetch_assoc();

      // Check if password matches
      if (password_verify($ppwd, $user['password'])) {
        $_SESSION['login'] = $puname;
        $_SESSION['id'] = $user['id'];
        $pid = $user['id'];
        $uip = $_SERVER['REMOTE_ADDR'];
        $status = 1;

        

        header("Location: patient_vitals.php");
        exit();
      } else {
        // Password incorrect
        $login_error = "Incorrect username or password";
      }
    } else {
      // Username does not exist or role not allowed
      $login_error = "User not allowed or does not exist";
    }
  }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Login Form</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: 'Arial', sans-serif;
      /* background-image: url('assets/images/b5.jpg'); */
      /* Replace with your image path */
      background-size: cover;
      background-repeat: no-repeat;
      background-position: center;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    /* [Styles same as your CSS above — preserved below for brevity] */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Arial', sans-serif;
      background-color: #f4f4f9;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .container {
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .login-box {
      background-color: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      width: 400px;
      max-width: 100%;
    }

    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }

    .input-group {
      margin-bottom: 20px;
    }

    .input-group label {
      font-size: 14px;
      color: #666;
    }

    .input-group input {
      width: 100%;
      padding: 12px;
      border: 1px solid #ddd;
      border-radius: 5px;
      margin-top: 5px;
      font-size: 14px;
    }

    .input-group input:focus {
      border-color: #3498db;
      outline: none;
    }

    .error-message {
      color: red;
      font-size: 12px;
      margin-top: 5px;
    }

    .submit-btn {
      width: 100%;
      padding: 12px;
      background-color: #3498db;
      border: none;
      color: white;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
    }

    .submit-btn:hover {
      background-color: #2980b9;
    }

    .forgot-password {
      text-align: center;
      margin-top: 10px;
    }

    .forgot-password a {
      color: #3498db;
      text-decoration: none;
    }

    .forgot-password a:hover {
      text-decoration: underline;
    }

    .signup-link {
      text-align: center;
      margin-top: 15px;
    }

    .signup-link a {
      color: #3498db;
      text-decoration: none;
    }

    .signup-link a:hover {
      text-decoration: underline;
    }

    @media (max-width: 480px) {
      .login-box {
        padding: 20px;
      }
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="login-box">
      <h2>Nurse Login</h2>
      <?php if (!empty($login_error)) echo "<p class='error-message' style='text-align:center;'>$login_error</p>"; ?>
      <form method="POST" id="login-form">
        <div class="input-group">
          <label for="username">Username</label>
          <input type="text" name="username" id="username" placeholder="Enter your username" required>
          <small id="username-error" class="error-message"></small>
        </div>

        <div class="input-group">
          <label for="password">Password</label>
          <input type="password" name="password" id="password" placeholder="Enter your password" required>
          <small id="password-error" class="error-message"></small>
        </div>

        <button type="submit" name="submit" class="submit-btn">Login</button>



        <!-- <div class="forgot-password">
          <a href="forgotpassword.php">Forgot Password?</a>
        </div> -->
      </form>

      <!-- <p class="signup-link">Don't have an account? <a href="registration.php">Sign up here</a></p> -->
    </div>
  </div>

  <script>
    document.getElementById('login-form').addEventListener('submit', function(event) {
      clearErrors();
      const username = document.getElementById('username').value.trim();
      const password = document.getElementById('password').value.trim();
      let isValid = true;

      if (username === '') {
        displayError('username', 'Username is required');
        isValid = false;
      }

      if (password === '') {
        displayError('password', 'Password is required');
        isValid = false;
      }

      if (!isValid) event.preventDefault(); // prevent if invalid
    });

    function displayError(field, message) {
      document.getElementById(`${field}-error`).textContent = message;
    }

    function clearErrors() {
      document.getElementById('username-error').textContent = '';
      document.getElementById('password-error').textContent = '';
    }
  </script>
</body>

</html>