<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$message = "";

// Fetch patients
$patientQuery = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patientQuery->execute();
$patientResult = $patientQuery->get_result();

// Handle form submission
if (isset($_POST['submit'])) {
    $patient_id   = intval($_POST['patient_id']);
    $weight       = floatval($_POST['weight']);
    $height       = floatval($_POST['height']);
    $temperature  = floatval($_POST['temperature']);
    $blood_pressure = trim($_POST['blood_pressure']);

    $stmt = $con->prepare("INSERT INTO patient_vitals (patient_id, weight, height, temperature, blood_pressure) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("iddds", $patient_id, $weight, $height, $temperature, $blood_pressure);

    if ($stmt->execute()) {
        $message = "✅ Patient vitals added successfully!";
    } else {
        $message = "❌ Error: " . $con->error;
    }
}

// Optional: pre-select patient
$selectedPatient = isset($_GET['patient_id']) ?
    $con->query("SELECT id as patient_id, fullName FROM users WHERE id=" . intval($_GET['patient_id']))->fetch_assoc() : null;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Add Patient Vitals</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-3">Add Patient Details / Vitals</h3>
                        </div>

                        <?php if ($message): ?>
                            <div class="alert alert-info"><?= htmlentities($message) ?></div>
                        <?php endif; ?>
                        <div class="card-body">
                            <?php if (!empty($message)): ?>
                                <div class="alert alert-info"><?= htmlentities($message); ?></div>
                            <?php endif; ?>
                            <form method="post">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Patient</label>
                                        <?php if ($selectedPatient): ?>
                                            <input type="hidden" name="patient_id" value="<?= $selectedPatient['patient_id'] ?>">
                                            <input type="text" class="form-control" value="<?= htmlentities($selectedPatient['fullName']) ?>" readonly>
                                        <?php else: ?>
                                            <select name="patient_id" class="form-control" required>
                                                <option value="">-- Select Patient --</option>
                                                <?php while ($row = $patientResult->fetch_assoc()) : ?>
                                                    <option value="<?= $row['id'] ?>"><?= htmlentities($row['fullName']) ?></option>
                                                <?php endwhile; ?>
                                            </select>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Weight (kg)</label>
                                        <input type="number" step="0.1" name="weight" class="form-control" required>
                                    </div>

                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Height (cm)</label>
                                        <input type="number" step="0.1" name="height" class="form-control" required>
                                    </div>

                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Temperature (°C)</label>
                                        <input type="number" step="0.1" name="temperature" class="form-control" required>
                                    </div>

                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Blood Pressure</label>
                                        <input type="text" name="blood_pressure" class="form-control" placeholder="e.g., 120/80" required>
                                    </div>
                                </div>

                                <button type="submit" name="submit" class="btn btn-primary mt-3">Save Vitals</button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="card shadow mt-4">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">Patient Vitals</h3>
                        </div>
                        <div class="card-body">
                                <table class="table table-hover" id="specilizationTable">
                                <thead class="thead-dark">
                                    <tr>
                                        <th class="center">No</th>
                                        <th>Patient Name</th>
                                        <th class="hidden-xs">Weight (kg)</th>
                                        <th>Height (cm)</th>
                                        <th>Temperature (°C)</th>
                                        <th>Blood Pressure</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = mysqli_query($con, "SELECT pv.*, u.fullName 
                                        FROM patient_vitals pv
                                        JOIN users u ON u.id = pv.patient_id;
                                        ");
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_array($sql)) {
                                    ?>

                                        <tr>
                                            <td class="center"><?php echo $cnt; ?>.</td>
                                            <td><?php echo $row['fullName']; ?></td>
                                            <td><?php echo $row['weight']; ?>
                                            <td><?php echo $row['height']; ?>
                                            <td><?php echo $row['temperature']; ?>
                                            <td><?php echo $row['blood_pressure']; ?>
                                            </td>

                                            
                                        </tr>

                                    <?php
                                        $cnt = $cnt + 1;
                                    } ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</body>

</html>