<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ============================
// Generate Next Invoice Number
// ============================
function generateInvoiceNo($con) {
    $result = $con->query("SELECT MAX(id) AS max_id FROM invoices");
    $row = $result->fetch_assoc();
    return 'INV-' . str_pad($row['max_id'] + 1, 5, '0', STR_PAD_LEFT);
}

// ============================
// Handle Form Submission
// ============================
if (isset($_POST['submit'])) {
    $invoice_no        = $_POST['invoice_no'];
    $invoice_date      = $_POST['invoice_date'];
    $client_name       = $_POST['client_name'];
    $client_contact_no = $_POST['client_contact_no'];
    $sub_amount        = $_POST['sub_amount'];
    $discount          = $_POST['discount'];
    $gst_amount        = $_POST['gst_amount'];
    $total_amount      = $_POST['total_amount'];
    $grand_total       = $_POST['grand_total'];
    $paid_amount       = $_POST['paid_amount'];
    $due_amount        = $_POST['due_amount'];
    $payment_status    = $_POST['payment_status'];
    $payment_type      = $_POST['payment_type'];
    $payment_place     = $_POST['payment_place'];

    // Insert into invoices table
    $stmt = $con->prepare("INSERT INTO invoices 
        (invoice_no, invoice_date, client_name, client_contact_no, sub_amount, discount, gst_amount, total_amount, grand_total, paid_amount, due_amount, payment_status, payment_type, payment_place) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param(
        "sssddddddddsss",
        $invoice_no, $invoice_date, $client_name, $client_contact_no,
        $sub_amount, $discount, $gst_amount, $total_amount, $grand_total,
        $paid_amount, $due_amount, $payment_status, $payment_type, $payment_place
    );
    $stmt->execute();
    $invoice_id = $stmt->insert_id;
    $stmt->close();

    // Insert invoice items
    foreach ($_POST['medicine_id'] as $index => $medicine_id) {
        $rate          = $_POST['rate'][$index];
        $available_qty = $_POST['available'][$index];
        $quantity      = $_POST['quantity'][$index];
        $total_price   = $_POST['total'][$index];

        $itemStmt = $con->prepare("INSERT INTO invoice_items 
            (invoice_id, medicine_id, rate, availability, stock_quantity, total_price) 
            VALUES (?, ?, ?, ?, ?, ?)");
        $itemStmt->bind_param("iiddid", $invoice_id, $medicine_id, $rate, $available_qty, $quantity, $total_price);
        $itemStmt->execute();
        $itemStmt->close();
    }

    echo "<script>alert('Invoice created successfully.'); window.location.href='add-invoice.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Pharmacy | Add Invoice</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />

</head>
<body>
<div class="container-scroller">
<?php include('include/sidebar.php'); ?>
<div class="container-fluid page-body-wrapper">
<?php include('include/header.php'); ?>
<div class="main-panel">
<div class="content-wrapper">

<section id="page-title">
    <div class="row">
        <div class="col-sm-8"><h1 class="mainTitle">Pharmacy | Add Invoice</h1></div>
    </div>
</section>
<a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>

<div class="container bg-white p-4 rounded shadow-sm">
<form method="POST">
<?php $new_invoice_no = generateInvoiceNo($con); ?>
<div class="row">
    <div class="col-md-4 mb-3">
        <label>Invoice No</label>
        <input type="text" class="form-control" name="invoice_no" value="<?= $new_invoice_no ?>" readonly />
    </div>
    <div class="col-md-4 mb-3">
        <label>Invoice Date</label>
        <input type="date" class="form-control" name="invoice_date" value="<?= date('Y-m-d') ?>">
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-6"><label>Client Name</label><input type="text" class="form-control" name="client_name" required></div>
    <div class="col-md-6"><label>Client Contact No.</label><input type="text" class="form-control" name="client_contact_no" required></div>
</div>

<div class="scroll-container">
<h5>Invoice Items</h5>
<table class="table table-bordered" id="medicineTable">
<thead>
<tr><th>Medicine</th><th>Rate</th><th>Available</th><th>Quantity</th><th>Total</th><th>Action</th></tr>
</thead>
<tbody>
<tr>
<td>
<select name="medicine_id[]" class="form-control medicine-select" required>
<option value="">-- Select Medicine --</option>
<?php
$medicines = mysqli_query($con, "SELECT id,name,rate,availability FROM medicine WHERE status='Available'");
while($m = mysqli_fetch_assoc($medicines)){
    echo '<option value="'.$m['id'].'" data-rate="'.$m['rate'].'" data-availability="'.$m['availability'].'">'.$m['name'].'</option>';
}
?>
</select>
</td>
<td><input type="text" name="rate[]" class="form-control" readonly></td>
<td><input type="text" name="available[]" class="form-control" readonly></td>
<td><input type="number" name="quantity[]" class="form-control" min="1"></td>
<td><input type="text" name="total[]" class="form-control" readonly></td>
<td>
<button type="button" class="btn btn-danger removeRow">Remove</button>
<button type="button" class="btn btn-success addRow">Add</button>
</td>
</tr>
</tbody>
</table>
</div>

<div class="row mt-3">
    <div class="col-md-4"><label>Sub Amount</label><input type="text" class="form-control" id="subAmount" name="sub_amount" readonly></div>
    <div class="col-md-4"><label>Discount</label><input type="text" class="form-control" id="discount" name="discount"></div>
</div>

<div class="row mt-2">
    <div class="col-md-4"><label>GST Amount</label><input type="text" class="form-control" id="gstAmount" name="gst_amount" readonly></div>
    <div class="col-md-4"><label>Total</label><input type="text" class="form-control" id="totalAmount" name="total_amount" readonly></div>
    <div class="col-md-4"><label>Grand Total</label><input type="text" class="form-control" id="grandTotal" name="grand_total" readonly></div>
</div>

<div class="row mt-2">
    <div class="col-md-4"><label>Paid Amount</label><input type="text" class="form-control" id="paidAmount" name="paid_amount"></div>
    <div class="col-md-4"><label>Due Amount</label><input type="text" class="form-control" id="dueAmount" name="due_amount" readonly></div>
</div>

<div class="row mt-2">
    <div class="col-md-4"><label>Payment Type</label>
        <select class="form-control" name="payment_type">
            <option value="">--SELECT--</option>
            <option value="Cash">Cash</option>
            <option value="Card">Card</option>
            <option value="UPI">UPI</option>
        </select>
    </div>
    <div class="col-md-4"><label>Payment Place</label>
        <select class="form-control" name="payment_place">
            <option value="">--SELECT--</option>
            <option value="Counter">Counter</option>
            <option value="Online">Online</option>
        </select>
    </div>
    <div class="col-md-4"><label>Payment Status</label>
        <select class="form-control" name="payment_status">
            <option value="">--SELECT--</option>
            <option value="Paid">Paid</option>
            <option value="Unpaid">Unpaid</option>
            <option value="Partial">Partial</option>
        </select>
    </div>
</div>

<div class="mt-4 text-end">
<button type="submit" name="submit" class="btn btn-success">Submit</button>
<button type="reset" class="btn btn-danger">Reset</button>
<button type="button" class="btn btn-primary" onclick="window.print()">Print Invoice</button>
</div>
</form>
</div>

</div>
<?php include('include/footer.php'); ?>
</div>
</div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function calculateRowTotal(row){
    const rate = parseFloat(row.find('input[name="rate[]"]').val())||0;
    const qty  = parseFloat(row.find('input[name="quantity[]"]').val())||0;
    const total = rate*qty;
    row.find('input[name="total[]"]').val(total.toFixed(2));
    return total;
}
function calculateInvoiceTotals(){
    let subAmount=0;
    $('#medicineTable tbody tr').each(function(){ subAmount += calculateRowTotal($(this)); });
    $('#subAmount').val(subAmount.toFixed(2));
    const discount = parseFloat($('#discount').val())||0;
    const gst = (subAmount - discount)*0.18;
    const total = subAmount - discount + gst;
    $('#gstAmount').val(gst.toFixed(2));
    $('#totalAmount').val(total.toFixed(2));
    $('#grandTotal').val(total.toFixed(2));
    const paid = parseFloat($('#paidAmount').val())||0;
    $('#dueAmount').val((total-paid).toFixed(2));
}

$(document).on('change','.medicine-select',function(){
    const selected=$(this).find('option:selected');
    const row=$(this).closest('tr');
    row.find('input[name="rate[]"]').val(selected.data('rate'));
    row.find('input[name="available[]"]').val(selected.data('availability'));
    calculateInvoiceTotals();
});

$(document).on('input','input[name="quantity[]"],#discount,#paidAmount',function(){ calculateInvoiceTotals(); });

$(document).on('click','.removeRow',function(){ $(this).closest('tr').remove(); calculateInvoiceTotals(); });

$(document).on('click','.addRow',function(){
    const newRow=`<tr>
        <td>
            <select name="medicine_id[]" class="form-control medicine-select" required>
                <option value="">-- Select Medicine --</option>
                <?php
                $medicines = mysqli_query($con, "SELECT id,name,rate,availability FROM medicine WHERE status='Available'");
                while($m = mysqli_fetch_assoc($medicines)){
                    echo '<option value="'.$m['id'].'" data-rate="'.$m['rate'].'" data-availability="'.$m['availability'].'">'.$m['name'].'</option>';
                }
                ?>
            </select>
        </td>
        <td><input type="text" name="rate[]" class="form-control" readonly></td>
        <td><input type="text" name="available[]" class="form-control" readonly></td>
        <td><input type="number" name="quantity[]" class="form-control" min="1"></td>
        <td><input type="text" name="total[]" class="form-control" readonly></td>
        <td>
            <button type="button" class="btn btn-danger removeRow">Remove</button>
            <button type="button" class="btn btn-success addRow">Add</button>
        </td>
    </tr>`;
    $('#medicineTable tbody').append(newRow);
});
</script>
</body>
</html>
