<?php
include('include/config.php');
if (isset($_POST['submit'])) {
    $return_no = $_POST['return_no'];
    $return_date = $_POST['return_date'];
    $reason = $_POST['reason'];
    $total = $_POST['total_return'];

    $stmt = $con->prepare("INSERT INTO returns (return_no, return_date, reason, total_return) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("sssd", $return_no, $return_date, $reason, $total);
    $stmt->execute();
    $return_id = $stmt->insert_id;

    foreach ($_POST['medicine_id'] as $i => $med_id) {
        $qty = $_POST['quantity'][$i];
        $amt = $_POST['return_amount'][$i];
        $con->query("INSERT INTO return_items (return_id, medicine_id, quantity, return_amount) 
            VALUES ('$return_id', '$med_id', '$qty', '$amt')");
    }

    echo "<script>alert('Return Submitted Successfully'); window.location.href='add-return.php';</script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Pharmacy | Return Entry</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Pharmacy | Return Entry</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Pharmacy</span></li>
                            <li class="active"><span>New Return</span></li>
                        </ol> -->
                    </div>
                </section>

                <a href="manage-vendor.php" class="btn btn-secondary mb-3">← Back to Manage Vendor</a>

                <form method="POST" action="" class="card p-4 shadow-sm">
                    <h3 class="mb-3 text-primary">Return Entry</h3>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Return No:</label>
                            <input type="text" name="return_no" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Return Date:</label>
                            <input type="date" name="return_date" class="form-control" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Reason:</label>
                        <textarea name="reason" rows="3" class="form-control"></textarea>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered" id="returnItems">
                            <thead class="table-light">
                                <tr>
                                    <th>Medicine</th>
                                    <th>Qty</th>
                                    <th>Amount</th>
                                    <th><button type="button" class="btn btn-sm btn-primary" onclick="addRow()">+</button></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <select name="medicine_id[]" class="form-select medicine-select" required>
                                            <option value="">-- Select --</option>
                                            <?php
                                            $res = $con->query("SELECT id, name, rate FROM medicine");
                                            while ($row = $res->fetch_assoc()) {
                                                echo "<option value='{$row['id']}' data-rate='{$row['rate']}'>{$row['name']}</option>";
                                            }
                                            ?>
                                        </select>
                                    </td>
                                    <td><input type="number" name="quantity[]" class="form-control qty" required></td>
                                    <td><input type="number" name="return_amount[]" class="form-control return-amount" required></td>
                                    <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Total Return Amount:</label>
                        <input type="text" name="total_return" id="totalReturn" class="form-control" readonly>
                    </div>

                    <div class="text-end">
                        <input type="submit" name="submit" value="Submit Return" class="btn btn-success">
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>

<script>
function addRow() {
    const row = `
        <tr>
            <td>
                <select name="medicine_id[]" class="form-select medicine-select" required>
                    <option value="">-- Select --</option>
                    <?php
                    $res = $con->query("SELECT id, name, rate FROM medicine");
                    while ($row = $res->fetch_assoc()) {
                        echo "<option value='{$row['id']}' data-rate='{$row['rate']}'>{$row['name']}</option>";
                    }
                    ?>
                </select>
            </td>
            <td><input type="number" name="quantity[]" class="form-control qty" required></td>
            <td><input type="number" name="return_amount[]" class="form-control return-amount" required></td>
            <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
        </tr>`;
    $('#returnItems tbody').append(row);
}

function removeRow(button) {
    $(button).closest('tr').remove();
    calculateTotal();
}

$(document).on('change', '.medicine-select', function () {
    const rate = $(this).find('option:selected').data('rate') || 0;
    const row = $(this).closest('tr');
    row.find('.return-amount').val(rate);
    calculateTotal();
});

$(document).on('input', '.return-amount, .qty', function () {
    calculateTotal();
});

function calculateTotal() {
    let total = 0;
    $('#returnItems tbody tr').each(function () {
        const qty = parseFloat($(this).find('.qty').val()) || 0;
        const amt = parseFloat($(this).find('.return-amount').val()) || 0;
        total += qty * amt;
    });
    $('#totalReturn').val(total.toFixed(2));
}
</script>

</body>
</html>
