<?php
session_start();
error_reporting(0);
include("include/config.php");

$msg = "";

if (isset($_POST['reset'])) {
  $username = trim($_POST['username']);
  $newpassword = trim($_POST['newpassword']);
  $confirmpassword = trim($_POST['confirmpassword']);

  if (empty($username) || empty($newpassword) || empty($confirmpassword)) {
    $msg = "All fields are required!";
  } elseif ($newpassword !== $confirmpassword) {
    $msg = "Passwords do not match!";
  } else {
    // Check if user exists
    $stmt = $con->prepare("SELECT id FROM pharmacy_users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
      // User exists - update password
      $hashed_password = password_hash($newpassword, PASSWORD_DEFAULT);
      $update = $con->prepare("UPDATE pharmacy_users SET password = ? WHERE username = ?");
      $update->bind_param("ss", $hashed_password, $username);
      if ($update->execute()) {
        $msg = "✅ Password updated successfully!";
      } else {
        $msg = "❌ Failed to update password.";
      }
    } else {
      $msg = "❌ Username not found!";
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Forgot Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f7f7f7;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .box {
      background: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      width: 400px;
      max-width: 90%;
    }

    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #2c3e50;
    }

    .input-group {
      margin-bottom: 15px;
    }

    label {
      display: block;
      margin-bottom: 5px;
      font-weight: bold;
    }

    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 10px;
      box-sizing: border-box;
      border: 1px solid #ccc;
      border-radius: 5px;
    }

    .btn {
      width: 100%;
      padding: 12px;
      background-color: #3498db;
      border: none;
      color: white;
      font-size: 16px;
      border-radius: 5px;
      cursor: pointer;
    }

    .btn:hover {
      background-color: #2980b9;
    }

    .msg {
      text-align: center;
      margin-top: 15px;
      color: red;
      font-weight: bold;
    }
  </style>
</head>
<body>

<div class="box">
  <h2>Forgot Password</h2>
  <form method="POST">
    <div class="input-group">
      <label for="username">Username</label>
      <input type="text" name="username" id="username" required>
    </div>
    <div class="input-group">
      <label for="newpassword">New Password</label>
      <input type="password" name="newpassword" id="newpassword" required>
    </div>
    <div class="input-group">
      <label for="confirmpassword">Confirm Password</label>
      <input type="password" name="confirmpassword" id="confirmpassword" required>
    </div>
    <button type="submit" name="reset" class="btn">Reset Password</button>
    <div class="msg"><?php echo htmlentities($msg); ?></div>
  <div class="d-flex justify-content-center mt-3 forgot-password">
  <a href="pharmacyindex.php">Login</a>
</div>
<style>
  .forgot-password {
    text-align: center; /* Center contents horizontally */
    margin-top: 20px;   /* Optional spacing from above */
  }

  .forgot-password a {
    color: #007bff;
    font-weight: 600;
    text-decoration: none;
  }

  .forgot-password a:hover {
    text-decoration: underline;
  }
</style>

<!-- <div class="forgot-password">
  <a href="pharmacyindex.php">Login</a>
</div> -->

  </form>
</div>

</body>
</html>
