<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// (Optional) Check login
if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>Manage Medicine</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
<style>
    .detail_modal { width: 80%; }
    table.dataTable thead .sorting, table.dataTable thead .sorting_asc, table.dataTable thead .sorting_desc, table.dataTable thead .sorting_asc_disabled, table.dataTable thead .sorting_desc_disabled {
    cursor: pointer;
    position: relative;
    color: white;
    background-color: black;
}
</style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Manage Medicine</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="medicineTable">
                                <thead>
                                    <tr>
                                        <th>SNO</th>
                                        <th>Medicine Code</th>
                                        <th>Medicine Name</th>
                                        <th>Batch No</th>
                                        <th>Composition</th>
                                        <th>Strength</th>
                                        <th>Unit Type</th>
                                        <th>Description</th>
                                        <th>Prescription</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $sql = mysqli_query($con, "SELECT * FROM medicine_masters ORDER BY id DESC");
                                while ($row = mysqli_fetch_assoc($sql)):
                                ?>
                                    <tr>
                                        <td></td>
                                        <td><?= htmlentities($row['medicine_code']); ?></td>
                                        <td><?= htmlentities($row['medicine_name']); ?></td>
                                        <td><?= htmlentities($row['batch_number']); ?></td>
                                        <td><?= htmlentities($row['composition']); ?></td>
                                        <td><?= htmlentities($row['strength']); ?></td>
                                        <td><?= htmlentities($row['unit_type']); ?></td>
                                        <td><?= htmlentities($row['description']); ?></td>
                                        <td><?= htmlentities($row['prescription_required']); ?></td>
                                        <!-- <td>
                                            <button class="btn btn-info btn-sm view-details"
                                                data-toggle="modal"
                                                data-target="#detailsModal"
                                                data-code="<?= htmlentities($row['medicine_code']); ?>"
                                                data-name="<?= htmlentities($row['medicine_name']); ?>"
                                                data-batch="<?= htmlentities($row['batch_number']); ?>"
                                                data-comp="<?= htmlentities($row['composition']); ?>"
                                                data-strength="<?= htmlentities($row['strength']); ?>"
                                                data-unit="<?= htmlentities($row['unit_type']); ?>"
                                                data-desc="<?= htmlentities($row['description']); ?>"
                                                data-pres="<?= ($row['prescription_required'] == 1 ? 'Yes' : 'No') ?>">View</button>
                                        </td> -->
                                    </tr>
                                <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Details Modal -->
                <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg detail_modal" role="document">
                        <div class="modal-content">
                            <div class="modal-header bg-primary text-white">
                                <h5 class="modal-title">Medicine Details</h5>
                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <table class="table table-bordered">
                                    <tr><th>Medicine Code</th><td id="mCode"></td></tr>
                                    <tr><th>Medicine Name</th><td id="mName"></td></tr>
                                    <tr><th>Batch No</th><td id="mBatch"></td></tr>
                                    <tr><th>Composition</th><td id="mComp"></td></tr>
                                    <tr><th>Strength</th><td id="mStrength"></td></tr>
                                    <tr><th>Unit Type</th><td id="mUnit"></td></tr>
                                    <tr><th>Description</th><td id="mDesc"></td></tr>
                                    <tr><th>Prescription Required</th><td id="mPres"></td></tr>
                                </table>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {
    var t = $('#medicineTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10,
        "lengthMenu": [5, 10, 20, 50]
    });

    // Auto update SNO
    t.on('order.dt search.dt', function () {
        t.column(0, { search:'applied', order:'applied' }).nodes().each(function(cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    // Pass details to modal
    $(document).on("click", ".view-details", function() {
        $("#mCode").text($(this).data("code"));
        $("#mName").text($(this).data("name"));
        $("#mBatch").text($(this).data("batch"));
        $("#mComp").text($(this).data("comp"));
        $("#mStrength").text($(this).data("strength"));
        $("#mUnit").text($(this).data("unit"));
        $("#mDesc").text($(this).data("desc"));
        $("#mPres").text($(this).data("pres"));
    });
});
</script>
</body>
</html>
