<?php
session_start();
error_reporting(0);
include('include/config.php');
include('include/checklogin.php');
// check_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Return Report</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
    <link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <style>
        .btn-primary {
            float: right;
        }
    </style>
</head>
<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            <div class="main-content">
                <div class="wrap-content container" id="container">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Return Report</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid container-fullw bg-white">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="text-end mb-3">
                                    <button onclick="printSection('print-area')" class="btn btn-primary">
                                        <i class="ti-printer"></i> Print
                                    </button>
                                </div>
                                <h5 class="over-title margin-bottom-15">Return Report</h5>
                                <div id="print-area">
                                    <table class="table table-striped table-bordered" id="example1">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>No</th>
                                                <th>Return Date</th>
                                                <th>Return No</th>
                                                <th>Medicine Name</th>
                                                <th>Quantity</th>
                                                <th>Return Amount</th>
                                                <th>Reason</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query = mysqli_query($con, "
                                                SELECT 
                                                    r.return_date, 
                                                    r.return_no, 
                                                    m.name AS medicine_name, 
                                                    ri.quantity, 
                                                    ri.return_amount, 
                                                    r.reason
                                                FROM returns r
                                                JOIN return_items ri ON r.id = ri.return_id
                                                JOIN medicine m ON ri.medicine_id = m.id
                                                ORDER BY r.return_date DESC
                                            ");
                                            $cnt = 1;
                                            while ($row = mysqli_fetch_assoc($query)) {
                                            ?>
                                                <tr>
                                                    <td><?php echo $cnt++; ?></td>
                                                    <td><?php echo htmlspecialchars($row['return_date']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['return_no']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['medicine_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['quantity']); ?></td>
                                                    <td><?php echo number_format($row['return_amount'], 2); ?></td>
                                                    <td><?php echo htmlspecialchars($row['reason']); ?></td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('include/footer.php'); ?>
        <?php include('include/setting.php'); ?>
    </div>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/main.js"></script>

    <!-- Print Function -->
    <script>
        function printSection(divId) {
            var printContents = document.getElementById(divId).innerHTML;
            var win = window.open('', '', 'height=700,width=900');
            win.document.write('<html><head><title>Return Report</title>');
            win.document.write('<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">');
            win.document.write('<style>table { width: 100%; border-collapse: collapse; } table, th, td { border: 1px solid black; padding: 8px; }</style>');
            win.document.write('</head><body>');
            win.document.write('<h3 class="text-center">Return Report</h3>');
            win.document.write(printContents);
            win.document.write('</body></html>');
            win.document.close();
            win.focus();
            win.print();
            win.close();
        }
    </script>

    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function () {
            $('#example1').DataTable();
        });
    </script>
</body>
</html>
 <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
