<?php
session_start();
include('include/config.php');

// Make sure patient is logged in
if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit();
}

$patientId = $_SESSION['id'];

// Get patient name from ID
$stmt = $con->prepare("SELECT fullName FROM users WHERE ID = ?");
$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$pname = $user['fullName'];

?>
<!DOCTYPE html>
<html>
<head>
    <title>Your Prescriptions</title>
		<link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            <div class="main-content">
                <div class="wrap-content container" id="container">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient | Your Prescriptions</h1>
                            </div>
                        </div>
                    </section>
<div class="container mt-5">
    <h3 class="mb-4">Prescriptions for <?php echo htmlspecialchars($pname); ?></h3>
<br>
    <?php
    // Get prescriptions for this patient
    $presStmt = $con->prepare("SELECT * FROM prescriptions WHERE pname = ? ORDER BY pid DESC");
    $presStmt->bind_param("s", $pname);
    $presStmt->execute();
    $presResult = $presStmt->get_result();

    if ($presResult->num_rows > 0) {
        while ($row = $presResult->fetch_assoc()) {
            echo "<div class='card mb-4'>";
            echo "<div class='card-header'><strong>Prescription ID: {$row['pid']}</strong></div>";
            echo "<div class='card-body'>";
            echo "<p><strong>Diagnosis:</strong> " . htmlspecialchars($row['diagnosis']) . "</p>";
            echo "<p><strong>Treatment:</strong> " . htmlspecialchars($row['treatment']) . "</p>";
            echo "<p><strong>Prescription:</strong> " . htmlspecialchars($row['prescription']) . "</p>";
            echo "<p><strong>Notes:</strong> " . htmlspecialchars($row['notes']) . "</p>";

            // Fetch medicines
            $pid = $row['pid'];
            $medStmt = $con->prepare("SELECT * FROM prescription_items WHERE pid = ?");
            $medStmt->bind_param("i", $pid);
            $medStmt->execute();
            $medResult = $medStmt->get_result();

            if ($medResult->num_rows > 0) {
                echo "<h5>Medicines:</h5>";
                echo "<table class='table table-bordered'><thead><tr><th>Name</th><th>Dosage</th><th>Duration</th></tr></thead><tbody>";
                while ($med = $medResult->fetch_assoc()) {
                    echo "<tr>
                            <td>" . htmlspecialchars($med['medicine_name']) . "</td>
                            <td>" . htmlspecialchars($med['dosage']) . "</td>
                            <td>" . htmlspecialchars($med['duration']) . "</td>
                        </tr>";
                }
                echo "</tbody></table>";
            } else {
                echo "<p>No medicines prescribed.</p>";
            }

            echo "</div></div>";
        }
    } else {
        echo "<div class='alert alert-info'>No prescriptions found.</div>";
    }
    ?>
</div>
</body>
</html>
 <?php include('include/footer.php'); ?>
        <?php include('include/setting.php'); ?>
    </div>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="vendor/autosize/autosize.min.js"></script>
<script src="vendor/selectFx/classie.js"></script>
<script src="vendor/selectFx/selectFx.js"></script>
<script src="vendor/select2/select2.min.js"></script>
<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/form-elements.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
        FormElements.init();
    });
</script>
</body>
</html>
