<?php
session_start();
error_reporting(0);
include('include/config.php');
include('include/checklogin.php');
check_login();

/*
|------------------------------------------------------------
| AJAX: return a doctor's shifts (HTML rows) for the modal
|------------------------------------------------------------
*/
if (isset($_GET['ajax']) && $_GET['ajax'] === 'shifts') {
    header('Content-Type: text/html; charset=UTF-8');
    $docId = intval($_GET['doc_id'] ?? 0);

    $days = [
        0 => 'Monday', 1 => 'Tuesday', 2 => 'Wednesday',
        3 => 'Thursday', 4 => 'Friday', 5 => 'Saturday', 6 => 'Sunday'
    ];

    if ($docId > 0) {
        $q = $con->prepare("SELECT day_id, shift_type, start_time, end_time
                            FROM doctor_shift_master
                            WHERE doc_id = ?
                            ORDER BY day_id, shift_type");
        $q->bind_param("i", $docId);
        $q->execute();
        $rs = $q->get_result();

        if ($rs->num_rows > 0) {
            while ($row = $rs->fetch_assoc()) {
                $day   = $days[$row['day_id']] ?? 'Invalid Day';
                $shift = htmlentities($row['shift_type']);
                $start = date("g:i A", strtotime($row['start_time']));
                $end   = date("g:i A", strtotime($row['end_time']));

                echo "<tr>
                        <td>{$day}</td>
                        <td>{$shift}</td>
                        <td>{$start}</td>
                        <td>{$end}</td>
                      </tr>";
            }
        } else {
            echo '<tr><td colspan="4" class="text-center text-muted">No shifts available.</td></tr>';
        }
        exit;
    }
    echo '<tr><td colspan="4" class="text-center text-danger">Invalid doctor.</td></tr>';
    exit;
}

// ------------------------------------------------------------
// Page data: distinct doctors this patient has booked before
// ------------------------------------------------------------
$userId = $_SESSION['id'] ?? 0;

$doctorsStmt = $con->prepare("
    SELECT DISTINCT d.id AS doctor_id, d.doctorName, d.specilization, d.docFees
    FROM appointment a
    INNER JOIN doctors d ON d.id = a.doctorId
    WHERE a.userId = ?
    ORDER BY d.doctorName ASC
");
$doctorsStmt->bind_param("i", $userId);
$doctorsStmt->execute();
$doctors = $doctorsStmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Patient | Doctors' Available Timings</title>
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="vendor/fontawesome/css/font-awesome.min.css" rel="stylesheet">
<link href="vendor/themify-icons/themify-icons.min.css" rel="stylesheet">
<link href="assets/css/styles.css" rel="stylesheet">
<link href="assets/css/plugins.css" rel="stylesheet">
<link href="assets/css/themes/theme-1.css" rel="stylesheet" id="skin_color" />
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
    <style>
        .table-sm th, .table-sm td { padding: .45rem; }
        .btn-sm { padding: .25rem .6rem; }
    </style>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Patient | Doctors' Available Timings</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="example1">
                                <thead>
                                    <tr>
                                        <th>SNO</th>
                                        <th>Doctor</th>
                                        <th>Specialization</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $i=1; while ($doc = $doctors->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= $i++; ?></td>
                                        <td><?= htmlentities($doc['doctorName']); ?></td>
                                        <td><?= htmlentities($doc['specilization']); ?></td>
                                        <td>
                                            <button class="btn btn-primary btn-sm view-timings"
                                                    data-doc-id="<?= (int)$doc['doctor_id']; ?>"
                                                    data-doc-name="<?= htmlentities($doc['doctorName']); ?>">
                                                <i class="fa fa-clock-o"></i> View Timings
                                            </button>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div><!-- /.container-fullw -->
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- MODAL -->
<div class="modal fade" id="timingsModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Timings for: <span id="doctorNameHead" class="text-primary"></span></h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <table class="table table-sm table-bordered mb-0">
            <thead>
                <tr>
                    <th>Day</th>
                    <th>Shift</th>
                    <th>Start</th>
                    <th>End</th>
                </tr>
            </thead>
            <tbody id="timingsBody">
                <tr><td colspan="4" class="text-center text-muted">Loading…</td></tr>
            </tbody>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
    $('#example1').DataTable();

    $('.view-timings').click(function(){
        var docId   = $(this).data('doc-id');
        var docName = $(this).data('doc-name');

        $('#doctorNameHead').text(docName);
        $('#timingsBody').html('<tr><td colspan="4" class="text-center text-muted">Loading…</td></tr>');
        $('#timingsModal').modal('show');

        $.get(window.location.pathname, { ajax: 'shifts', doc_id: docId }, function(html){
            $('#timingsBody').html(html);
        }).fail(function(){
            $('#timingsBody').html('<tr><td colspan="4" class="text-center text-danger">Failed to load.</td></tr>');
        });
    });
});
</script>
</body>
</html>
