<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Ensure patient is logged in
if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit();
}

$patientId = $_SESSION['id'];

// Get patient name
$stmt = $con->prepare("SELECT fullName FROM users WHERE ID = ?");
$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$pname = $user['fullName'];
$stmt->close();

// Fetch prescriptions for this patient
$query = "
    SELECT p.id AS pid, p.notes, p.scan, p.lab, p.revisit_date, p.created_at
    FROM prescriptions p
    WHERE p.patient_id = ?
    ORDER BY p.id DESC";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Patient | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">

                    <div class="card shadow mt-4">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">View Prescriptions</h3>
                        </div>
                        <div class="card-body">
                            <table id="prescriptionTable" class="table table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>No</th>
                                        <th>Notes</th>
                                        <th>Revisit Date</th>
                                        <th>Appointment Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cnt = 1;
                                    if ($result->num_rows == 0) {
                                        echo "<tr><td colspan='5' class='text-center text-danger'>No prescriptions found.</td></tr>";
                                    } else {
                                        while ($row = $result->fetch_assoc()) {
                                            $revisitFormatted = !empty($row['revisit_date']) ? date("d/m/Y", strtotime($row['revisit_date'])) : '';
                                            $createdFormatted = !empty($row['created_at']) ? date("d/m/Y h:i A", strtotime($row['created_at'])) : '';                                        ?>

                                            <tr>
                                                <td><?= $cnt++; ?></td>
                                                <td><?= htmlentities(substr($row['notes'], 0, 50)); ?>...</td>
                                                <td><?= $revisitFormatted; ?></td>
                                                <td><?= $createdFormatted; ?></td>
                                                <td>
                                                    <button class="btn btn-info btn-sm view-details"
                                                        data-toggle="modal"
                                                        data-target="#detailsModal"
                                                        data-id="<?= $row['pid']; ?>"
                                                        data-patient="<?= htmlentities($pname); ?>"
                                                        data-notes="<?= htmlentities($row['notes']); ?>"
                                                        data-scan="<?= htmlentities($row['scan']); ?>"
                                                        data-lab="<?= htmlentities($row['lab']); ?>"
                                                        data-revisit="<?= $row['revisit_date']; ?>"
                                                        data-created="<?= $createdFormatted; ?>">
                                                        View
                                                    </button>
                                                </td>
                                            </tr>
                                    <?php }
                                    } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Details Modal -->
                    <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Prescription Details</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body" id="printArea">
                                    <h5>Prescription Info</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Patient</th>
                                            <td id="dPatient"></td>
                                        </tr>
                                        <tr>
                                            <th>Notes</th>
                                            <td id="dNotes"></td>
                                        </tr>
                                        <tr>
                                            <th>Scan</th>
                                            <td id="dScan"></td>
                                        </tr>

                                        <tr>
                                            <th>Revisit</th>
                                            <td id="dRevisit"></td>
                                        </tr>
                                        <tr>
                                            <th>Appointment Date</th>
                                            <td id="dCreated"></td>
                                        </tr>
                                    </table>

                                    <h5 class="mt-4">Medicines</h5>
                                    <div id="medicineDetails">Loading...</div>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-success" id="printBtn"><i class="fa fa-print"></i> Print</button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#prescriptionTable').DataTable();

            $(document).on("click", ".view-details", function() {
                $("#dPatient").text($(this).data("patient"));
                $("#dNotes").text($(this).data("notes"));
                $("#dScan").text($(this).data("scan"));
                $("#dLab").text($(this).data("lab"));

                // Format revisit
                let revisitDate = $(this).data("revisit");
                if (revisitDate) {
                    let d = new Date(revisitDate);
                    $("#dRevisit").text(("0" + d.getDate()).slice(-2) + "/" +
                        ("0" + (d.getMonth() + 1)).slice(-2) + "/" +
                        d.getFullYear());
                } else {
                    $("#dRevisit").text("");
                }

                $("#dCreated").text($(this).data("created"));

                var prescriptionId = $(this).data("id");
                $("#medicineDetails").html("Loading...");
                $.get("fetch-medicines.php", {
                    pid: prescriptionId
                }, function(data) {
                    $("#medicineDetails").html(data);
                });
            });

            $("#printBtn").click(function() {
                let printContents = document.getElementById("printArea").innerHTML;
                let originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;
                location.reload();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $(".main-navigation-menu li > a").click(function(e) {
                var parentLi = $(this).parent("li");

                // If this menu has a submenu
                if (parentLi.find(".sub-menu").length > 0) {
                    e.preventDefault(); // Prevent going to link

                    // Toggle submenu
                    parentLi.toggleClass("open");
                    parentLi.find(".sub-menu").slideToggle(200);

                    // Close other open menus (optional)
                    parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
                }
            });
        });
    </script>

</body>

</html>