<?php
if (isset($_POST['userName']) && isset($_POST['password'])) {
    include 'config.php';

    $db = new DB_Connect();
    $con = $db->connect();

    // Sanitize and assign user input
    $username = $_POST["userName"];
    $password = $_POST["password"];

    try {
        // Prepare the SQL statement to prevent SQL injection
        $sql_query = "SELECT * FROM `user_master` WHERE `user_name` = :userName";
        $stmt = $con->prepare($sql_query);
        
        // Bind parameters
        $stmt->bindParam(':userName', $username, PDO::PARAM_STR);
        
        if ($stmt->execute()) {
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $result = array("status" => "false");

            foreach ($res as $row) {
                // Direct password comparison (no hashing)
                if ($password === $row["password"] && $row["status"] == 1) {
                    $result = array(
                        "status" => "true",
                        "userId" => $row["id"],
                        "email" => $row["email"]
                    );
                }
            }

            echo json_encode($result);
        } else {
            echo json_encode(array("status" => "error", "message" => "Query execution failed"));
        }

        // Close the statement (optional, PDO handles it automatically)
        $stmt = null;
    } catch (PDOException $e) {
        // Handle exceptions, such as connection or query errors
        echo json_encode(array("status" => "error", "message" => $e->getMessage()));
    } finally {
        // Close the PDO connection
        $con = null;
    }
} else {
    // Handle case when form is not submitted or data is missing
    echo json_encode(array("status" => "error", "message" => "Username or password not provided"));
}
?>
