<?php
include("config.php");
require 'sendMail.php';

try {
    $db = new DB_Connect();
    $con = $db->connect();

    $userName = $_POST['userName'];
    $password = $_POST['password'];
    $email = $_POST['email'];

    $otp = rand(1000000, 10000000);

    $subject = "PMG Play App SignUp OTP";

    $message = "Dear " . $userName . ",<br/><br/>

    Welcome, to the PMG Play App! Please enter<br/> 
    the OTP below to signup to our services.<br/><br/>

    OTP - " . $otp . "<br/><br/>

    We are thrilled to welcome you to the PMG Play App!<br/><br/>

    Regards,<br/>
    Pioneer Music Gym Team";

    // Check if the username exists in `user_master`
    $stmt = $con->prepare("SELECT COUNT(*) FROM `user_master` WHERE `user_name` = :userName");
    $stmt->bindParam(':userName', $userName);
    $stmt->execute();
    $userMasterCount = $stmt->fetchColumn();

    $result = ["status" => "false"];

    if ($userMasterCount == 0) {
        // Check if the username exists in `signup`
        $stmt = $con->prepare("SELECT COUNT(*) FROM `signup` WHERE `user_name` = :userName");
        $stmt->bindParam(':userName', $userName);
        $stmt->execute();
        $signupCount = $stmt->fetchColumn();

        if ($signupCount == 0) {
            // Insert new record into `signup`
            $stmt = $con->prepare("INSERT INTO `signup` (`user_name`, `password`, `email`, `otp`) 
                                    VALUES (:userName, :password, :email, :otp)");
            $stmt->bindParam(':userName', $userName);
            $stmt->bindParam(':password', $password);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':otp', $otp);
            $stmt->execute();

            if (sendMail($email, $subject, $message)) {
                $result = ["status" => "true"];
            }
        } else {
            // Update existing record in `signup`
            $stmt = $con->prepare("DELETE FROM `signup` WHERE `user_name` = :userName");
            $stmt->bindParam(':userName', $userName);
            $stmt->execute();

            $stmt = $con->prepare("INSERT INTO `signup` (`user_name`, `password`, `email`, `otp`) 
                                    VALUES (:userName, :password, :email, :otp)");
            $stmt->bindParam(':userName', $userName);
            $stmt->bindParam(':password', $password);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':otp', $otp);
            $stmt->execute();

            if (sendMail($email, $subject, $message)) {
                $result = ["status" => "true"];
            }
        }
    }

    echo json_encode([$result]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
