<?php
include("config.php");

try {
    // Connect to the database using PDO
    $db = new DB_Connect();
    $con = $db->connect();

    // Retrieve POST data
    $index = $_POST["index"] ?? null;
    $limit = $_POST["limit"] ?? null;

    if (!isset($index, $limit)) {
        echo json_encode(['status' => false, 'message' => 'Missing index or limit']);
        exit;
    }

    // SQL query with placeholders
    $sql_query = "SELECT com.id AS composer_id,
                        com.composer_name,
                        (SELECT COUNT(*) 
                            FROM movie_composer mov_com
                            INNER JOIN song_master sm ON mov_com.movie_id = sm.movie_id
                            WHERE mov_com.composer_id = com.id) AS number_of_songs,
                        (SELECT COUNT(*)
                            FROM movie_composer mov_com
                            WHERE mov_com.composer_id = com.id) AS number_of_movies
                  FROM composers com
                  ORDER BY com.composer_name ASC
                  LIMIT :index, :limit";

    // Prepare the statement
    $stmt = $con->prepare($sql_query);

    // Bind parameters
    $stmt->bindParam(':index', $index, PDO::PARAM_INT);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Initialize the result array
    $result = ['status' => false, 'composers' => []];

    // Fetch all rows
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $result['status'] = true;
        $result['composers'][] = [
            '0' => $row['composer_id'],
            '1' => $row['composer_name'],
            '2' => $row['number_of_songs'],
            '3' => $row['number_of_movies'],
        ];
    }

    // Output the result as JSON
    echo json_encode($result);

} catch (PDOException $e) {
    // Handle database errors
    echo json_encode(['status' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
